﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_StringView.h>
#include <nn/fs/fs_Mount.h>

namespace nn { namespace ncm { namespace detail {

    Result EnsureDirectoryRecursively(const char* path) NN_NOEXCEPT;
    Result EnsureParentDirectoryRecursively(const char* path) NN_NOEXCEPT;
    Result HasDirectory(bool* outValue, const char* path) NN_NOEXCEPT;
    Result HasFile(bool* outValue, const char* path) NN_NOEXCEPT;
    Result CopyFile(const char* destinationPath, const char* sourcePath) NN_NOEXCEPT;

    class PathView
    {
    public:
        NN_IMPLICIT PathView(util::string_view path) : m_Path(path){}
        bool HasSuffix(util::string_view suffix) const NN_NOEXCEPT;
        bool HasPrefix(util::string_view prefix) const NN_NOEXCEPT;
        util::string_view GetFileName() const NN_NOEXCEPT;

    private:
        util::string_view m_Path;
    };

    struct MountName
    {
        char string[fs::MountNameLengthMax + 1];
    };

    struct RootDirectoryPath
    {
        char string[fs::MountNameLengthMax + 3];
    };

    MountName CreateUniqueMountName() NN_NOEXCEPT;

    RootDirectoryPath GetRootDirectoryPath(const MountName& mountName) NN_NOEXCEPT;
}}}
