﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>

#include <nn/lr/lr_Result.h>
#include <nn/lr/lr_RedirectOnlyLocationResolverImpl.h>

namespace nn { namespace lr {

    Result RedirectOnlyLocationResolverImpl::ResolveProgramPath(sf::Out<Path> outValue, ncm::ProgramId id) NN_NOEXCEPT
    {
        Path path;
        if (m_ProgramRedirector.FindRedirection(&path, id))
        {
            outValue.Set(path);
            NN_RESULT_SUCCESS;
        }

        NN_RESULT_THROW(ResultProgramNotFound());
    }

    Result RedirectOnlyLocationResolverImpl::RedirectProgramPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        m_ProgramRedirector.SetRedirection(id, path);

        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::RedirectApplicationProgramPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        m_ProgramRedirector.SetRedirection(id, path, static_cast<int>(RedirectionFlag::Application));

        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::ResolveDataPath(sf::Out<Path> outValue, ncm::DataId id) NN_NOEXCEPT
    {
        NN_UNUSED(outValue);
        NN_UNUSED(id);

        NN_RESULT_THROW(ResultDataNotFound());
    }

    Result RedirectOnlyLocationResolverImpl::ResolveApplicationControlPath(sf::Out<Path> outValue, ncm::ProgramId id) NN_NOEXCEPT
    {
        Path path;
        if (m_ControlRedirector.FindRedirection(&path, id))
        {
            outValue.Set(path);
            NN_RESULT_SUCCESS;
        }

        NN_RESULT_THROW(ResultControlNotFound());
    }

    Result RedirectOnlyLocationResolverImpl::RedirectApplicationControlPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        m_ControlRedirector.SetRedirection(id, path, static_cast<int>(RedirectionFlag::Application));

        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::ResolveApplicationHtmlDocumentPath(sf::Out<Path> outValue, ncm::ProgramId id) NN_NOEXCEPT
    {
        Path path;
        if (m_HtmlDocumentRedirector.FindRedirection(&path, id))
        {
            outValue.Set(path);
            NN_RESULT_SUCCESS;
        }

        NN_RESULT_THROW(ResultHtmlDocumentNotFound());
    }

    Result RedirectOnlyLocationResolverImpl::RedirectApplicationHtmlDocumentPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        m_HtmlDocumentRedirector.SetRedirection(id, path, static_cast<int>(RedirectionFlag::Application));

        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::ResolveApplicationLegalInformationPath(sf::Out<Path> outValue, ncm::ProgramId id) NN_NOEXCEPT
    {
        Path path;
        if (m_LegalInformationRedirector.FindRedirection(&path, id))
        {
            outValue.Set(path);
            NN_RESULT_SUCCESS;
        }

        NN_RESULT_THROW(ResultLegalInformationNotFound());
    }

    Result RedirectOnlyLocationResolverImpl::RedirectApplicationLegalInformationPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        m_LegalInformationRedirector.SetRedirection(id, path, static_cast<int>(RedirectionFlag::Application));

        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::Refresh() NN_NOEXCEPT
    {
        ClearRedirection(static_cast<int>(RedirectionFlag::None));
        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::ClearApplicationRedirection() NN_NOEXCEPT
    {
        ClearRedirection(static_cast<int>(RedirectionFlag::Application));
        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::EraseProgramRedirection(ncm::ProgramId id) NN_NOEXCEPT
    {
        m_ProgramRedirector.EraseRedirection(id);

        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::EraseApplicationControlRedirection(ncm::ProgramId id) NN_NOEXCEPT
    {
        m_ControlRedirector.EraseRedirection(id);
        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::EraseApplicationHtmlDocumentRedirection(ncm::ProgramId id) NN_NOEXCEPT
    {
        m_HtmlDocumentRedirector.EraseRedirection(id);
        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::EraseApplicationLegalInformationRedirection(ncm::ProgramId id) NN_NOEXCEPT
    {
        m_LegalInformationRedirector.EraseRedirection(id);
        NN_RESULT_SUCCESS;
    }

    Result RedirectOnlyLocationResolverImpl::ClearRedirection(int flag) NN_NOEXCEPT
    {
        m_ProgramRedirector.ClearRedirection(flag);
        m_ControlRedirector.ClearRedirection(flag);
        m_HtmlDocumentRedirector.ClearRedirection(flag);
        m_LegalInformationRedirector.ClearRedirection(flag);

        NN_RESULT_SUCCESS;
    }
}}
