﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/lr/lr_LocationResolver.h>
#include <nn/lr/lr_ILocationResolver.h>

namespace nn { namespace lr {

    Result LocationResolver::ResolveProgramPath(Path* outValue, ncm::ProgramId id) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->ResolveProgramPath(outValue, id);
    }

    void LocationResolver::RedirectProgramPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        NN_ABORT_UNLESS(m_Interface->RedirectProgramPath(id, path).IsSuccess());
    }

    void LocationResolver::RedirectApplicationProgramPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        NN_ABORT_UNLESS(m_Interface->RedirectApplicationProgramPath(id, path).IsSuccess());
    }

    Result LocationResolver::ResolveDataPath(Path* outValue, ncm::DataId id) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->ResolveDataPath(outValue, id);
    }

    Result LocationResolver::ResolveApplicationControlPath(Path* outValue, ncm::ProgramId id) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->ResolveApplicationControlPath(outValue, id);
    }

    void LocationResolver::RedirectApplicationControlPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        NN_ABORT_UNLESS(m_Interface->RedirectApplicationControlPath(id, path).IsSuccess());
    }

    Result LocationResolver::ResolveApplicationHtmlDocumentPath(Path* outValue, ncm::ProgramId id) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->ResolveApplicationHtmlDocumentPath(outValue, id);
    }

    void LocationResolver::RedirectApplicationHtmlDocumentPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        NN_ABORT_UNLESS(m_Interface->RedirectApplicationHtmlDocumentPath(id, path).IsSuccess());
    }

    Result LocationResolver::ResolveApplicationLegalInformationPath(Path* outValue, ncm::ProgramId id) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->ResolveApplicationLegalInformationPath(outValue, id);
    }

    void LocationResolver::RedirectApplicationLegalInformationPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        NN_ABORT_UNLESS(m_Interface->RedirectApplicationLegalInformationPath(id, path).IsSuccess());
    }

    Result LocationResolver::Refresh() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->Refresh();
    }

    Result LocationResolver::ClearApplicationRedirection() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->ClearApplicationRedirection();
    }

    Result LocationResolver::EraseProgramRedirection(ncm::ProgramId programId) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->EraseProgramRedirection(programId);
    }

    Result LocationResolver::EraseApplicationControlRedirection(ncm::ProgramId programId) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->EraseApplicationControlRedirection(programId);
    }

    Result LocationResolver::EraseApplicationHtmlDocumentRedirection(ncm::ProgramId programId) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->EraseApplicationHtmlDocumentRedirection(programId);
    }

    Result LocationResolver::EraseApplicationLegalInformationRedirection(ncm::ProgramId programId) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Interface);

        return m_Interface->EraseApplicationLegalInformationRedirection(programId);
    }
}}
