﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ldr/ldr_ProcessManagerApi.h>
#include <nn/ldr/detail/ldr_ProcessManagerInterface.h>

#include <nn/svc/svc_Handle.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn { namespace ldr {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::ldr::detail::IProcessManagerInterface> g_RefProcessManagerInterface;
        bool g_IsInitialized = false;
    }

    Result InitializeForProcessManager() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<nn::ldr::detail::IProcessManagerInterface, MyAllocator::Policy>(
            &g_RefProcessManagerInterface, nn::ldr::detail::PortNameForProcessManager);
        if( result.IsSuccess() )
        {
            g_IsInitialized = true;
        }

        return result;
    }

    Result FinalizeForProcessManager() NN_NOEXCEPT
    {
        NN_ABORT("not implemented");
        return ResultSuccess();
    }

    Result CreateProcess(nn::svc::Handle* pOut, PinId pinId, int flags, nn::svc::Handle resourceLimit) NN_NOEXCEPT
    {
        nn::sf::NativeHandle nh;
        nn::sf::NativeHandle resourceLimitNh(
            nn::os::NativeHandle(static_cast<nnHandle>(resourceLimit).value),
            false);
        auto r = g_RefProcessManagerInterface->CreateProcess(
            &nh,
            pinId,
            flags,
            ::std::move(resourceLimitNh));
        *pOut = nn::svc::Handle(nh.GetOsHandle());
        nh.Detach();
        return r;
    }

    Result GetProgramInfo(ProgramInfo* pOut, const ncm::ProgramLocation& location) NN_NOEXCEPT
    {
        return g_RefProcessManagerInterface->GetProgramInfo(pOut, location);
    }

    Result PinProgram(PinId* pOutId, const ncm::ProgramLocation& programLocation) NN_NOEXCEPT
    {
        return g_RefProcessManagerInterface->PinProgram(pOutId, programLocation);
    }

    Result UnpinProgram(PinId id) NN_NOEXCEPT
    {
        return g_RefProcessManagerInterface->UnpinProgram(id);
    }

}}
