﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "hws_MsgProc.h"

namespace nn { namespace hws {

namespace {

MsgProc& s_Instance = MsgProc::GetInstance();

}

LRESULT MsgProc::MsgProcImpl( HWND hWnd, UINT msg, WPARAM wparam, LPARAM lparam )
{
    switch( msg )
    {
    case WM_CLOSE:
        {
            PostQuitMessage( 0 );
        }
        return 0;
    case WM_MOUSEWHEEL:
        {
            s_Instance.m_MouseWheel += GET_WHEEL_DELTA_WPARAM( wparam );
        }
        break;
    default:
        // なにもしない
        break;
    }

    return DefWindowProcA( hWnd, msg, wparam, lparam );
}

}
} // namespace nn
