﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.htclow.detail
{
    [CppRefPath(@"<nn/htclow/detail/htclow_DebugTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct DriverType{}
}

namespace nn.htclow.detail
{
    [CppRefPath(@"<nn/htclow/detail/htclow_IDebugServiceObject.h>")]
    public interface IDebugServiceObject: IServiceObject
    {
        [MethodId(0)]
        Result SendFromTest(InBuffer buffer);

        [MethodId(1)]
        Result ReceiveFromTest(OutBuffer outBuffer);

        [MethodId(2)]
        Result OpenDriver(DriverType driverType);

        [MethodId(3)]
        Result CloseDriver();

        [MethodId(4)]
        Result GetDefaultAllocatorUsage(Out<uint64_t> outSize);

        [MethodId(5)]
        Result PrintDefaultAllocatorUsage();
    }
}
