﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Allocator.h>
#include <nn/sf/impl/sf_AllocationPolicies.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace htc { namespace tenv { namespace detail {

    void InitializeAllocator(AllocateFunction alloc, DeallocateFunction dealloc) NN_NOEXCEPT;

    void* Allocate(size_t size) NN_NOEXCEPT;
    void Deallocate(void* addr, size_t size) NN_NOEXCEPT;

    class SfAllocator
    {
    public:
        SfAllocator() NN_NOEXCEPT {}
        typedef nn::sf::impl::StatelessAllocationPolicy<SfAllocator> Policy;
        void* Allocate(size_t size) NN_NOEXCEPT
        {
            return nn::htc::tenv::detail::Allocate(size);
        }
        void Deallocate(void* p, size_t size) NN_NOEXCEPT
        {
            return nn::htc::tenv::detail::Deallocate(p, size);
        }
    };

    typedef nn::sf::ObjectFactory<SfAllocator::Policy> ObjectFactory;

    template <class T>
    struct StdAllocator : public std::allocator<T>
    {
        StdAllocator(){}
        StdAllocator(const StdAllocator&){}
        template<class U>
        StdAllocator(const StdAllocator<U>&){}

        template<class U>
        struct rebind
        {
            typedef StdAllocator<U> other;
        };

        T* allocate(size_t size, const T* hint = 0)
        {
            NN_UNUSED(hint);
            return static_cast<T*>(nn::htc::tenv::detail::Allocate(sizeof(T) * size));
        }
        void deallocate(T* p, size_t size)
        {
            nn::htc::tenv::detail::Deallocate(p, sizeof(T) * size);
        }
    };

}}}}
