﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>

#include "htc_TenvAllocator.h"

namespace nn { namespace htc { namespace tenv { namespace detail {

    namespace
    {
#if defined(NN_BUILD_CONFIG_OS_WIN)
        void* StdAllocate(size_t size) NN_NOEXCEPT
        {
            return std::malloc(size);
        }

        void StdDeallocate(void* p, size_t size) NN_NOEXCEPT
        {
            NN_UNUSED(size);
            return std::free(p);
        }

        AllocateFunction g_Alloc = StdAllocate;
        DeallocateFunction g_Dealloc = StdDeallocate;
//        size_t g_Count = 0;
#else
        AllocateFunction g_Alloc = nullptr;
        DeallocateFunction g_Dealloc = nullptr;
#endif
    }

    void InitializeAllocator(AllocateFunction alloc, DeallocateFunction dealloc) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(g_Alloc == nullptr);
        NN_SDK_REQUIRES(g_Dealloc == nullptr);

        NN_SDK_REQUIRES_NOT_NULL(alloc);
        NN_SDK_REQUIRES_NOT_NULL(dealloc);

        g_Alloc = alloc;
        g_Dealloc = dealloc;
    }

    void* Allocate(size_t size) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(g_Alloc);
        // g_Count += size;
        // NN_SDK_LOG("Allocate: %d\n", g_Count);
        return g_Alloc(size);
    }

    void Deallocate(void* addr, size_t size) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(g_Dealloc);
        // g_Count -= size;
        // NN_SDK_LOG("Free: %d\n", g_Count);
        return g_Dealloc(addr, size);
    }

}}}}
