﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.htc.tenv
{
    [CppRefPath(@"<nn/htc/tenv/htc_TenvIService.h>")]
    public struct VariableName
    {
        [FixedArray(64)]
        public char_t[] str;
    }

    [CppRefPath(@"<nn/htc/tenv/htc_TenvIService.h>")]
    public interface IService : IServiceObject
    {
        [MethodId(0)]
        Result GetVariable(Out<int64_t> outValue, OutBuffer outBuffer, VariableName variableName);

        [MethodId(1)]
        Result GetVariableLength(Out<int64_t> outValue, VariableName variableName);

        [MethodId(2)]
        Result WaitUntilVariableAvailable(int64_t timeOutMilliSeconds);
    }

    [CppRefPath(@"<nn/htc/tenv/htc_TenvIServiceManager.h>")]
    public interface IServiceManager : IServiceObject
    {
        [MethodId(0)]
        Result GetServiceInterface(Out<IService> outValue, [ProcessId] nn.Bit64 processId);
    }

}
