﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

void PresetInternalKeys(const void* encryptedKeyBuffer, const size_t encryptedKeyBufferSize,
                        const void* socCertBuffer, const size_t socCertBufferSize) NN_NOEXCEPT
{
    NN_UNUSED(encryptedKeyBuffer);
    NN_UNUSED(encryptedKeyBufferSize);
    NN_UNUSED(socCertBuffer);
    NN_UNUSED(socCertBufferSize);
    return;
}

void Initialize(void* workBuffer, const size_t workBufferLength, nn::dd::DeviceVirtualAddress workBufferDeviceVirtualAddress) NN_NOEXCEPT
{
    NN_UNUSED(workBuffer);
    NN_UNUSED(workBufferLength);
    NN_UNUSED(workBufferDeviceVirtualAddress);
    g_IsGcLibInitialized = true;
    return;
}

void Finalize() NN_NOEXCEPT
{
    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    g_IsGcLibInitialized = false;
    return;
}

void PowerOffGameCard() NN_NOEXCEPT
{
    return;
}

void RegisterDeviceVirtualAddress(const uintptr_t bufferAddress, const size_t bufferSize, const nn::dd::DeviceVirtualAddress bufferDeviceVirtualAddress) NN_NOEXCEPT
{
    NN_UNUSED(bufferAddress);
    NN_UNUSED(bufferSize);
    NN_UNUSED(bufferDeviceVirtualAddress);
    return;
}

void UnregisterDeviceVirtualAddress(const uintptr_t bufferAddress, const size_t bufferSize, const nn::dd::DeviceVirtualAddress bufferDeviceVirtualAddress) NN_NOEXCEPT
{
    NN_UNUSED(bufferAddress);
    NN_UNUSED(bufferSize);
    NN_UNUSED(bufferDeviceVirtualAddress);
    return;
}

nn::Result GetInitializationResult() NN_NOEXCEPT
{
    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    NN_RESULT_SUCCESS;
}

nn::Result Activate() NN_NOEXCEPT
{
    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    NN_RESULT_SUCCESS;
}

void Deactivate() NN_NOEXCEPT
{
    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    return;
}

nn::Result SetCardToSecureMode() NN_NOEXCEPT
{
    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    NN_RESULT_SUCCESS;
}

nn::Result Read(void* outDataBuffer, const size_t bufferLength, const uint32_t pageAddress, const uint32_t pageCount) NN_NOEXCEPT
{
    NN_UNUSED(outDataBuffer);
    NN_UNUSED(bufferLength);
    NN_UNUSED(pageAddress);
    NN_UNUSED(pageCount);

    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    NN_RESULT_SUCCESS;
}

void PutToSleep() NN_NOEXCEPT
{
    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    return;
}

void Awaken() NN_NOEXCEPT
{
    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    return;
}

nn::Result GetCardStatus(GameCardStatus* pOutValue) NN_NOEXCEPT
{
    NN_UNUSED(pOutValue);

    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    NN_RESULT_SUCCESS;
}

bool IsCardInserted() NN_NOEXCEPT
{
    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    return false;
}

bool IsCardActivationValid() NN_NOEXCEPT
{
    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    return true;
}

nn::Result GetCardDeviceId(void* outBuffer, const size_t outBufferSize) NN_NOEXCEPT
{
    NN_UNUSED(outBuffer);
    NN_UNUSED(outBufferSize);

    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    NN_RESULT_SUCCESS;
}

nn::Result GetCardDeviceCertificate(void* outBuffer,const size_t outBufferSize) NN_NOEXCEPT
{
    NN_UNUSED(outBuffer);
    NN_UNUSED(outBufferSize);

    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    NN_RESULT_SUCCESS;
}

nn::Result GetCardImageHash(void* outBuffer, const size_t outBufferSize) NN_NOEXCEPT
{
    NN_UNUSED(outBuffer);
    NN_UNUSED(outBufferSize);

    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    NN_RESULT_SUCCESS;
}

nn::Result GetGameCardIdSet(GameCardIdSet* pOutValue) NN_NOEXCEPT
{
    NN_UNUSED(pOutValue);
    NN_RESULT_SUCCESS;
}

void RegisterDetectionEventCallback(nn::gc::detail::GcCallbackFunctionPointer const pDetectionEventCallback, void* const pParameter) NN_NOEXCEPT
{
    NN_UNUSED(pDetectionEventCallback);
    NN_UNUSED(pParameter);
    return;
}

void UnregisterDetectionEventCallback() NN_NOEXCEPT
{
    return;
}

Result GetCardHeader(void* outBuffer, const size_t outBufferSize) NN_NOEXCEPT
{
    NN_UNUSED(outBuffer);
    NN_UNUSED(outBufferSize);

    NN_DETAIL_GC_CHECK_IF_GCLIB_INITIALIZED;
    NN_RESULT_SUCCESS;
}
