﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SystemThreadDefinition.h>
#include <nn/fs/fs_PriorityPrivate.h>
#include <nn/fssystem/fs_ServiceContext.h>
#include <nn/fssystem/fs_ThreadPriorityChanger.h>

namespace nn { namespace fssystem {

int ScopedThreadPriorityChangerByAccessPriority::GetThreadPriorityByAccessPriority(AccessMode accessMode) NN_NOEXCEPT
{
    int priorityThread;
    switch( fssystem::GetServiceContextReadOnly().GetPriority() )
    {
    case fs::PriorityRaw_Normal:
        if( accessMode == AccessMode::Write )
        {
            priorityThread = NN_SYSTEM_THREAD_PRIORITY(fs, WorkerLowPriorityAccess);
        }
        else
        {
            priorityThread = NN_SYSTEM_THREAD_PRIORITY(fs, WorkerNormalPriorityAccess);
        }
        break;
    case fs::PriorityRaw_Realtime:
        priorityThread = NN_SYSTEM_THREAD_PRIORITY(fs, WorkerRealTimeAccess);
        break;
    case fs::PriorityRaw_Low:
        priorityThread = NN_SYSTEM_THREAD_PRIORITY(fs, WorkerLowPriorityAccess);
        break;
    case fs::PriorityRaw_Background:
        priorityThread = NN_SYSTEM_THREAD_PRIORITY(fs, WorkerBackgroundAccess);
        break;
    default:
        // ServiceContext で これ以外の優先度は設定されないようにする。
        // このため、ここには来ない想定。
        NN_UNEXPECTED_DEFAULT;
    }

    return priorityThread;
}

}}
