﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/fs/fs_Directory.h>
#include <nn/fssystem/fs_PathOnExecutionDirectory.h>

#if defined(NN_BUILD_CONFIG_OS_WIN32)

#include <nn/fs/fs_ResultPrivate.h>
#include <nn/nn_Windows.h>
#include <nn/util/util_FormatString.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>

namespace nn { namespace fssystem {

    PathOnExecutionDirectory::PathOnExecutionDirectory(const char* additionalPath) NN_NOEXCEPT
    {
        char moduleFileName[nn::fs::EntryNameLengthMax + 1];
        NN_FS_ABORT_UNLESS_WITH_RESULT(
            ::GetModuleFileNameA(NULL, moduleFileName, nn::fs::EntryNameLengthMax + 1) != 0,
            nn::fs::ResultUnexpectedInPathOnExecutionDirectoryA(),
            "Failed to get execution directory path.");

        char driveName[3];
        char dirName[nn::fs::EntryNameLengthMax + 1];
        ::_splitpath_s(moduleFileName, driveName, 3, dirName, nn::fs::EntryNameLengthMax + 1, NULL, 0, NULL, 0);

        char path[nn::fs::EntryNameLengthMax + 1];
        ::sprintf_s(path, nn::fs::EntryNameLengthMax + 1, "%s%s%s/", driveName, dirName, additionalPath);

        // UTF-8 に変換
        static const int WindowsPathLengthMax = 260;
        wchar_t pathW[WindowsPathLengthMax + 1];
        int multiLength =  static_cast<int>(strnlen_s(path, nn::fs::EntryNameLengthMax));

        std::memset(pathW, 0, sizeof(pathW));
        int wideResult = ::MultiByteToWideChar(CP_ACP, NULL, path, -1, pathW, WindowsPathLengthMax + 1);
        if (multiLength > 0)
        {
            // MultiByteToWideChar()のinのバッファサイズが常にsizeof(path)とした場合、outバッファサイズより大きくなってしまっているため、strnlen_sで可変に変更
            // inのバッファサイズが固定の場合、常に0x0000007Aのバッファエラーが発生
            // 変換文字列がある条件で結果をチェック（変換対象の文字列長が０の場合、戻りも０となるため）
            NN_FS_ABORT_UNLESS_WITH_RESULT(wideResult != 0, nn::fs::ResultUnexpectedInPathOnExecutionDirectoryB(), "Error(0x%08x) has occurred in MultiByteToWideChar.\n",  GetLastError());
        }
        int multiResult = ::WideCharToMultiByte(CP_UTF8, NULL, pathW, -1, m_PathOnExecutionDirectory, sizeof(m_PathOnExecutionDirectory), NULL, NULL);
        NN_FS_ABORT_UNLESS_WITH_RESULT(multiResult != 0, nn::fs::ResultUnexpectedInPathOnExecutionDirectoryC(), "Error(0x%08x) has occurred in WideCharToMultiByte.\n",  GetLastError());
        for (char* p = m_PathOnExecutionDirectory; *p != '\0'; ++p)
        {
            if (*p == '\\')
            {
                *p = '/';
            }
        }
    }

}}

#endif

