﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/os/os_SdkThreadLocalStorage.h>
#include <nn/fssystem/buffers/fs_BufferManagerUtility.h>

namespace
{
    nn::os::SdkThreadLocalStorage g_TlsForBufferManagerContext;
}

namespace nn { namespace fssystem { namespace buffers {

void RegisterBufferManagerContext(const BufferManagerContext* pContext) NN_NOEXCEPT
{
    g_TlsForBufferManagerContext.SetValue(reinterpret_cast<uintptr_t>(pContext));
}

void EnableBlockingBufferManagerAllocation() NN_NOEXCEPT
{
    auto pContext = GetBufferManagerContext();
    if( pContext != nullptr )
    {
        pContext->SetNeedBlocking(true);
    }
}

BufferManagerContext* GetBufferManagerContext() NN_NOEXCEPT
{
    return reinterpret_cast<BufferManagerContext*>(g_TlsForBufferManagerContext.GetValue());
}

}}}
