﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.fs
{
    [CppRefPath(@"<nn/fs/fs_ErrorInfoPrivate.h>")]
    [ExternalStruct(16, 8)]
    public struct StorageErrorInfo
    {
    }

    [CppRefPath(@"<nn/fs/fs_GameCard.h>")]
    [ExternalStruct(16, 8)]
    public struct GameCardErrorInfo
    {
    }

    [CppRefPath(@"<nn/fs/fs_GameCard.h>")]
    [ExternalStruct(64, 8)]
    public struct GameCardErrorReportInfo
    {
    }
}

namespace nn.fssrv.sf
{
    [CppRefPath(@"<nn/fssrv/sf/fssrv_IDeviceOperator.h>")]
    public interface IDeviceOperator : IServiceObject
    {
        // SD
        [MethodId(0)]
        Result IsSdCardInserted(Out<bool> outValue);

        [MethodId(1)]
        Result GetSdCardSpeedMode(Out<int64_t> outValue);

        [MethodId(2)]
        Result GetSdCardCid(OutBuffer outBuffer, int64_t size);

        [MethodId(3)]
        Result GetSdCardUserAreaSize(Out<int64_t> outValue);

        [MethodId(4)]
        Result GetSdCardProtectedAreaSize(Out<int64_t> outValue);

        [MethodId(5)]
        Result GetAndClearSdCardErrorInfo(Out<nn.fs.StorageErrorInfo> outStorageErrorInfo, Out<int64_t> outLogSize, OutBuffer outLogBuffer, int64_t logBufferSize);

        // MMC
        [MethodId(100)]
        Result GetMmcCid(OutBuffer outBuffer, int64_t size);

        [MethodId(101)]
        Result GetMmcSpeedMode(Out<int64_t> outValue);

        [MethodId(110)]
        Result EraseMmc(uint32_t id);

        [MethodId(111)]
        Result GetMmcPartitionSize(Out<int64_t> outValue, uint32_t id);

        [MethodId(112)]
        Result GetMmcPatrolCount(Out<uint32_t> outValue);

        [MethodId(113)]
        Result GetAndClearMmcErrorInfo(Out<nn.fs.StorageErrorInfo> outStorageErrorInfo, Out<int64_t> outLogSize, OutBuffer outLogBuffer, int64_t logBufferSize);

        [MethodId(114)]
        Result GetMmcExtendedCsd(OutBuffer outBuffer, int64_t size);

        [MethodId(115)]
        Result SuspendMmcPatrol();

        [MethodId(116)]
        Result ResumeMmcPatrol();

        // GC
        [MethodId(200)]
        Result IsGameCardInserted(Out<bool> outValue);

        [MethodId(201)]
        Result EraseGameCard(uint32_t memorySizeId, uint64_t normalAreaSize);

        [MethodId(202)]
        Result GetGameCardHandle(Out<uint32_t> outValue);

        [MethodId(203)]
        Result GetGameCardUpdatePartitionInfo(Out<uint32_t> outVersion, Out<uint64_t> outId, uint32_t handle);

    　　[MethodId(204)]
        Result FinalizeGameCardDriver();

        [MethodId(205)]
        Result GetGameCardAttribute(Out<uint8_t> outValue, uint32_t handle);

        [MethodId(206)]
        Result GetGameCardDeviceCertificate(OutBuffer outBuffer, int64_t outBufferSize, uint32_t handle);

        [MethodId(207)]
        Result GetGameCardAsicInfo(OutBuffer outBuffer, int64_t outBufferSize, InBuffer inBuffer, int64_t inBufferSize);

        [MethodId(208)]
        Result GetGameCardIdSet(OutBuffer outBuffer, int64_t outBufferSize);

        [MethodId(209)]
        Result WriteToGameCardDirectly(int64_t offset, OutBuffer outBuffer, int64_t outBufferSize);

        [MethodId(210)]
        Result SetVerifyWriteEnalbleFlag(bool flag);

        [MethodId(211)]
        Result GetGameCardImageHash(OutBuffer outBuffer, int64_t outBufferSize, uint32_t handle);

        [MethodId(212)]
        Result GetGameCardDeviceIdForProdCard(OutBuffer outBuffer, int64_t outBufferSize, InBuffer inBuffer, int64_t inBufferSize);

        [MethodId(213)]
        Result EraseAndWriteParamDirectly(InBuffer inBuffer, int64_t inBufferSize);

        [MethodId(214)]
        Result ReadParamDirectly(OutBuffer outBuffer, int64_t outBufferSize);

        [MethodId(215)]
        Result ForceEraseGameCard();

        [MethodId(216)]
        Result GetGameCardErrorInfo(Out<nn.fs.GameCardErrorInfo> outValue);

        [MethodId(217)]
        Result GetGameCardErrorReportInfo(Out<nn.fs.GameCardErrorReportInfo> outValue);

        [MethodId(218)]
        Result GetGameCardDeviceId(OutBuffer outBuffer, int64_t outBufferSize);

        // SpeedEmulation
        [MethodId(300)]
        Result SetSpeedEmulationMode(int32_t mode);

        [MethodId(301)]
        Result GetSpeedEmulationMode(Out<int32_t> outValue);

        // SdmmcControl
        [MethodId(400)]
        Result SuspendSdmmcControl();

        [MethodId(401)]
        Result ResumeSdmmcControl();

        [MethodId(402)]
        Result GetSdmmcConnectionStatus(Out<int32_t> outSdmmcSpeedMode, Out<int32_t> outSdmmcBusWidth, int32_t sdmmcPort);

        // AccessSimulation
        [MethodId(500)]
        Result SetDeviceSimulationEvent(uint32_t deviceType, uint32_t targetOperationFlag, uint32_t deviceEventType, uint32_t respondingFailureResultValue, bool isPersistent);

        [MethodId(501)]
        Result ClearDeviceSimulationEvent(uint32_t deviceType);
    }
}
