﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>

#include <nn/fs/fs_Result.h>
#include <nn/fs/fsa/fs_IDirectory.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/fssystem/fs_AllocatorUtility.h>
#include <nn/fssystem/fs_SubdirectoryFileSystem.h>

#include <nn/fssrv/fscreator/fssrv_SubDirectoryFileSystemCreator.h>

namespace nn { namespace fssrv { namespace fscreator {

    SubDirectoryFileSystemCreator::SubDirectoryFileSystemCreator() NN_NOEXCEPT
    {
    }

    Result SubDirectoryFileSystemCreator::Create(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, std::shared_ptr<nn::fs::fsa::IFileSystem> fileSystem, const char* path) NN_NOEXCEPT
    {
        return Create(outValue, fileSystem, path, false);
    }

    Result SubDirectoryFileSystemCreator::Create(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, std::shared_ptr<nn::fs::fsa::IFileSystem> fileSystem, const char* path, bool isUncPreserved) NN_NOEXCEPT
    {
        std::unique_ptr<nn::fs::fsa::IDirectory> dir;
        NN_RESULT_DO(fileSystem->OpenDirectory(&dir, path, nn::fs::OpenDirectoryMode_Directory));
        dir.reset(nullptr);

        std::shared_ptr<fssystem::SubdirectoryFileSystem> pFs = fssystem::AllocateShared<fssystem::SubdirectoryFileSystem>(std::move(fileSystem), path, isUncPreserved);
        NN_RESULT_THROW_UNLESS(pFs, nn::fs::ResultAllocationMemoryFailedInSubDirectoryFileSystemCreatorA());
        *outValue = std::move(pFs);
        NN_RESULT_SUCCESS;
    }

}}}
