﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkLog.h>

#include "fssrv_SystemDataUpdateEventNotifier.h"
#include "fssrv_SystemDataUpdateEventManager.h"

namespace nn { namespace fssrv { namespace detail {

    SystemDataUpdateEventNotifier::SystemDataUpdateEventNotifier(SystemDataUpdateEventManager* pManager) NN_NOEXCEPT : m_Manager(pManager)
    {
    }

    SystemDataUpdateEventNotifier::~SystemDataUpdateEventNotifier() NN_NOEXCEPT
    {
        nn::os::DestroySystemEvent(&m_SystemEvent);
        m_Manager->DeleteNotifier(this);
    }

    Result SystemDataUpdateEventNotifier::GetEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    {
        auto handle = nn::os::GetReadableHandleOfSystemEvent(&m_SystemEvent);
        outValue.Set(nn::sf::NativeHandle(handle, false));

        NN_RESULT_SUCCESS;
    }

    nn::os::SystemEventType* SystemDataUpdateEventNotifier::GetEvent() NN_NOEXCEPT
    {
        return &m_SystemEvent;
    }

}}}
