﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace fssrv { namespace detail {

    class SystemDataUpdateEventNotifier;
    class SystemDataUpdateEventManager
    {
    public:
        SystemDataUpdateEventManager() NN_NOEXCEPT;
        virtual ~SystemDataUpdateEventManager() NN_NOEXCEPT;

        Result CreateNotifier(std::unique_ptr<SystemDataUpdateEventNotifier>* outValue) NN_NOEXCEPT;
        Result NotifySystemDataUpdateEvent() NN_NOEXCEPT;

        // この関数は直接実行しないでください。 SystemDataUpdateEventNotifier のデストラクタでのみ呼ばれる想定です。
        void DeleteNotifier(SystemDataUpdateEventNotifier* pEventNotifier) NN_NOEXCEPT;

    protected:
        typedef nn::util::IntrusiveList<SystemDataUpdateEventNotifier, nn::util::IntrusiveListBaseNodeTraits<SystemDataUpdateEventNotifier>> SystemDataUpdateEventNotifierList;

    private:
        SystemDataUpdateEventNotifierList m_List;
        nn::os::Mutex m_Mutex;
    };

}}}
