﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/account/account_Types.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/fs/detail/fs_Newable.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/crypto/crypto_Sha256Generator.h>
#include <nn/fssrv/fssrv_SaveDataTransferCryptoConfiguration.h>
#include <nn/fssrv/detail/fssrv_ISaveDataTransferCoreInterface.h>
#include <nn/fs/fs_SaveDataTransferVersion2.h>
#include "fssrv_SaveDataTransferStream.h"

namespace nn { namespace fssrv { namespace sf {
    class ISaveDataTransferManagerWithDivision;
    class ISaveDataDivisionExporter;
    class ISaveDataDivisionImporter;
    class ISaveDataChunkIterator;
    class ISaveDataChunkExporter;
    class ISaveDataChunkImporter;
}}}

namespace nn { namespace fssrv { namespace detail {

    class SaveDataPorterManager;

    struct InitialDataVersion2Detail
    {
    public:
        static const int ChunkDigestCountMax = 128;
        static const size_t MacSize = crypto::Aes128GcmEncryptor::MacSize;

        struct Hash
        {
            static const size_t Size = nn::crypto::Sha256Generator::HashSize;
            char value[Size];
        };

        struct Content : public fs::detail::Newable
        {
            struct {
                fs::SaveDataExtraData extraData;
                int divisionCount;
                Hash chunkDigest[ChunkDigestCountMax];
                int64_t chunkSize[ChunkDigestCountMax]; // TODO: 実 divisionCount 分のみ
                char chunkMac[ChunkDigestCountMax][MacSize];
                int64_t internalStorageSize;
                fs::detail::InitialDataAad aad;
                char reserved[416];
            } singleSaveData;
        };

    public:

        AesGcmStreamHeader aesGcmStreamHeader;
        Content            content;
        AesGcmStreamTail   aesGcmStreamTail;
    };
    NN_STATIC_ASSERT(sizeof(InitialDataVersion2Detail) == 8192);
    NN_STATIC_ASSERT(sizeof(InitialDataVersion2Detail) == sizeof(fs::InitialDataVersion2));

#if !defined(NN_BUILD_CONFIG_COMPILER_GCC)
    NN_STATIC_ASSERT(std::is_trivially_copyable<InitialDataVersion2Detail>::value);
#endif

    class SaveDataTransferManagerVersion2
    {
    public:

        struct Challenge
        {
        public:
            static const int Size = 16;

        public:
            char data[Size];
        };

        struct KeySeedPackage
        {
        public:
            static const int EncryptOffset = 128;
            static const int EncryptedSize = 384;
            static const int SignTargetOffset = 384;
            static const int SignTargetSize = 128;

            struct Content
            {
                char sdaId[8];
                char applicationId[8];
                char keySeed[16];
                char initialDataMac[16];
                char challenge[16];
                char reserverd2[64];
            };

        public:
            char version[16];
            char kspIv[16];
            char kspMac[16];
            char reserved1[80];

            struct {
                char sign[256];
                Content signedArea;
            } encryptedArea;

        public:
            static const int Size = 512;

        };
        NN_STATIC_ASSERT(std::is_pod<KeySeedPackage>::value);
        NN_STATIC_ASSERT(sizeof(KeySeedPackage) == KeySeedPackage::Size);
        NN_STATIC_ASSERT(sizeof(KeySeedPackage) == sizeof(fs::SaveDataTransferManagerVersion2::KeySeedPackage));

        // obsolete
        using Token = KeySeedPackage;

    public:
        SaveDataTransferManagerVersion2(const SaveDataTransferCryptoConfiguration& configuration, ISaveDataTransferCoreInterface* pImpl, SaveDataPorterManager* pPorterManager) NN_NOEXCEPT;
        Result GetChallenge(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        Result SetKeySeedPackage(const nn::sf::InBuffer& kspBuffer) NN_NOEXCEPT;
        Result OpenSaveDataExporter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataDivisionExporter>> outValue, uint8_t saveDataSpaceId, uint64_t saveDataId) NN_NOEXCEPT;
        Result OpenSaveDataExporterForDiffExport(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataDivisionExporter>> outValue, const nn::sf::InBuffer& initialDataBuffer, uint8_t saveDataSpaceId, uint64_t saveDataId) NN_NOEXCEPT;
        Result OpenSaveDataImporter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataDivisionImporter>> outValue, const nn::sf::InBuffer& initialDataBuffer, const fs::UserId& userId, uint8_t saveDataSpaceId) NN_NOEXCEPT;
        Result OpenSaveDataImporterForDiffImport(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataDivisionImporter>> outValue, const nn::sf::InBuffer& initialDataBuffer, uint8_t saveDataSpaceId, uint64_t saveDataId) NN_NOEXCEPT;
        Result OpenSaveDataImporterForDuplicateDiffImport(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataDivisionImporter>> outValue, const nn::sf::InBuffer& initialDataBuffer, uint8_t saveDataSpaceId, uint64_t saveDataId) NN_NOEXCEPT;

    private:
        Result DecryptAndVerifyInitialData(std::unique_ptr<InitialDataVersion2Detail::Content>* pOutValue, const InitialDataVersion2Detail& untrustedInitialDataBuffer) NN_NOEXCEPT;

    private:
        nn::sf::SharedPointer<ISaveDataTransferCoreInterface> m_pImpl;
        const SaveDataTransferCryptoConfiguration& m_Configuration;
        bool m_IsKspSet = false;
        Challenge m_Challenge;

        KeySeedPackage::Content m_KeySeedPackage;
        SaveDataPorterManager* m_pPorterManager;
    };

}}}

