﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/crypto/crypto_Aes128GcmDecryptor.h>
#include <nn/fssrv/sf/fssrv_ISaveDataTransfer.h>

namespace nn {

namespace fs { namespace fsa {
    class IFileSystem;
}}

namespace fssrv { namespace detail {

    class SaveDataMacUpdater : public fs::detail::Newable
    {
    public:
        explicit SaveDataMacUpdater(std::shared_ptr<fs::fsa::IFileSystem> fileSystem);
        Result UpdateMac() NN_NOEXCEPT;

    private:
        const std::shared_ptr<fs::fsa::IFileSystem> m_FileSystem;
    };


    class ISaveDataTransferCoreInterface;
    class SaveDataImporter
    {
    public:
        SaveDataImporter(
            nn::sf::SharedPointer<ISaveDataTransferCoreInterface> pImpl,
            const fs::SaveDataInfo& info,
            std::shared_ptr<fs::fsa::IFile>&& file,
            int64_t fileSize,
            std::unique_ptr<SaveDataMacUpdater>&& macUpdater,
            std::unique_ptr<crypto::Aes128GcmDecryptor>&& decryptor) NN_NOEXCEPT;
        ~SaveDataImporter() NN_NOEXCEPT;

        // sf
        nn::Result GetSaveDataInfo(nn::sf::Out<nn::fs::SaveDataInfo> outValue) NN_NOEXCEPT;
        nn::Result GetRestSize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT;
        nn::Result Push(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result Finalize() NN_NOEXCEPT;

    private:
        nn::sf::SharedPointer<ISaveDataTransferCoreInterface> m_pImpl;
        fs::SaveDataInfo m_SaveDataInfo;
        bool m_IsFinalized;
        uint64_t m_Pushed;
        uint64_t m_Length;
        std::shared_ptr<fs::fsa::IFile> m_pFile;
        int64_t m_FileOffset;
        std::unique_ptr<crypto::Aes128GcmDecryptor> m_pDecryptor;
        char m_Mac[crypto::Aes128GcmDecryptor::MacSize];
        std::unique_ptr<SaveDataMacUpdater> m_MacUpdater;
    };

}}}
