﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <mutex>
#include <nn/fs/fs_QueryRange.h>
#include <nn/fs/detail/fs_IFileSystemPointer.h>
#include <nn/fssrv/detail/fssrv_IFileSystemProxyForAdapter.h>
#include <nn/fssrv/sf/fssrv_IFileSystem.h>
#include <nn/fssystem/fs_Utility.h>
#include <nn/os/os_ReaderWriterLock.h>

#include "fssrv_SharedLock.h"

namespace nn { namespace fssrv { namespace detail {

    class MultiCommitManager
    {
        NN_DISALLOW_COPY(MultiCommitManager);

    public:
        MultiCommitManager() NN_NOEXCEPT;

        nn::Result Add(nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem> fileSystem) NN_NOEXCEPT;

        nn::Result Commit() NN_NOEXCEPT;

    private:
        nn::Result CommitFileSystem() NN_NOEXCEPT;

    private:
        std::shared_ptr<nn::fs::fsa::IFileSystem> m_pFileSystems[fs::detail::CommittableCountMax];
        int m_FileSystemCount;
        int64_t m_Counter;
    };

}}}
