﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_GameCard.h>
#include <nn/fs/fs_DeviceSimulation.h>
#include <nn/gc/gc.h>
#include "fssrv_SdmmcStorageService.h"  // DeviceDetectionEventCallback
#include "fssrv_DeviceEventSimulator.h"

namespace nn { namespace fssrv { namespace detail {

    void InitializeGameCardManager() NN_NOEXCEPT;
    void PresetInternalKeys(const void* encryptedKeyBuffer, const size_t encryptedKeyBufferSize,
                            const void* socCertBuffer, const size_t socCertBufferSize) NN_NOEXCEPT;

    void InitializeGcLibrary() NN_NOEXCEPT;
    void FinalizeGcLibrary() NN_NOEXCEPT;

    void PutGameCardToSleep() NN_NOEXCEPT;
    void AwakenGameCard() NN_NOEXCEPT;
    void ShutdownGameCard() NN_NOEXCEPT;

    Result GetGameCardHandle(nn::fs::GameCardHandle* pOutValue) NN_NOEXCEPT;

    // @pre InitializeGcLibrary() 済
    Result ReadGameCard(nn::fs::GameCardHandle handle, int64_t offset, void* buffer, size_t size) NN_NOEXCEPT;

    // @pre InitializeGcLibrary() 済
    Result WriteGameCard(nn::fs::GameCardHandle handle, int64_t offset, const void* buffer, size_t size) NN_NOEXCEPT;
    Result WriteToGameCardDirectly(size_t offset, char* pInOutBuffer, size_t bufferSize) NN_NOEXCEPT;
    Result EraseGameCard(nn::fs::GameCardSize size, uint64_t nomarlAreaSize) NN_NOEXCEPT;

    void DeactivateGameCard() NN_NOEXCEPT;
    Result EnsureGameCardNormalMode(nn::fs::GameCardHandle* pOutValue) NN_NOEXCEPT;
    Result EnsureGameCardSecureMode(nn::fs::GameCardHandle* pOutValue) NN_NOEXCEPT;
    Result EnsureGameCardWriteMode(nn::fs::GameCardHandle* pOutValue) NN_NOEXCEPT;

    //! false の場合に valid とは限らない
    bool IsInvalidHandle(nn::fs::GameCardHandle handle) NN_NOEXCEPT;

    bool IsGameCardActivationValid(nn::fs::GameCardHandle handle) NN_NOEXCEPT;
    bool IsGameCardInserted() NN_NOEXCEPT;
    bool IsGameCardSecureMode() NN_NOEXCEPT;
    void RegisterGameCardDetectionEventCallback(DeviceDetectionEventCallback callback, void* pParameter) NN_NOEXCEPT;
    void UnregisterGameCardDetectionEventCallback() NN_NOEXCEPT;
    Result GetInitializationResult() NN_NOEXCEPT;
    Result GetGameCardRawSize(int64_t* pOutValue) NN_NOEXCEPT;
    Result GetGameCardIdSet(gc::GameCardIdSet* pOutValue) NN_NOEXCEPT;
    Result GetGameCardDeviceId(void* pOutValue, size_t size) NN_NOEXCEPT;
    Result GetGameCardImageHash(char* outBuffer, size_t outBufferSize) NN_NOEXCEPT; // GameCardStorageCreator 向け I/F

    Result GetGameCardErrorInfo(nn::fs::GameCardErrorInfo* pOutValue) NN_NOEXCEPT;
    Result GetGameCardErrorReportInfo(nn::fs::GameCardErrorReportInfo* pOutValue) NN_NOEXCEPT;

    void SetVerifyWriteEnalbleFlag(bool flag) NN_NOEXCEPT;
    // TODO: 必要に応じて細分化
    Result GetGameCardStatus(nn::gc::GameCardStatus* pOutValue, nn::fs::GameCardHandle handle) NN_NOEXCEPT;

    Result GetGameCardDeviceCertificate(char* pOutBuffer, size_t size, nn::fs::GameCardHandle handle) NN_NOEXCEPT;
    Result GetGameCardImageHash(char* outBuffer, size_t outBufferSize, nn::fs::GameCardHandle handle) NN_NOEXCEPT;

    // 製造・修理向け
    Result GetGameCardAsicInfo(gc::RmaInformation* pOutValue,const char* pFirmwareBuffer, size_t size) NN_NOEXCEPT;

    // XCIE ライター向け
    Result GetGameCardDeviceIdForProdCard(char* outBuffer, size_t outBufferSize, const char* devHeaderBuffer, size_t devHeaderBufferSize) NN_NOEXCEPT;
    Result EraseAndWriteParamDirectly(const char* inBuffer, size_t inBufferSize) NN_NOEXCEPT;
    Result ReadParamDirectly(char* outBuffer, size_t outBufferSize) NN_NOEXCEPT;
    Result ForceEraseGameCard() NN_NOEXCEPT;
}}}

