﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_ProgramRegistry.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include <nn/fssrv/sf/fssrv_IProgramRegistry.h>

#include "fs_FileSystemProxyServiceObject.h"

namespace nn { namespace fs {

    Result RegisterProgram(uint64_t processId, uint64_t programId, uint8_t storageId, const void* fsAccessControlData, size_t dataSize, const void* fsAccessControlDesc, size_t descSize) NN_NOEXCEPT
    {
        nn::sf::SharedPointer<nn::fssrv::sf::IProgramRegistry> pProgramRegistry = detail::GetProgramRegistryServiceObject();
        NN_FS_RESULT_DO(pProgramRegistry->SetCurrentProcess(0));
        NN_FS_RESULT_DO(pProgramRegistry->RegisterProgram(processId, programId, storageId, nn::sf::InBuffer(reinterpret_cast<const char*>(fsAccessControlData), dataSize), static_cast<int64_t>(dataSize), nn::sf::InBuffer(reinterpret_cast<const char*>(fsAccessControlDesc), descSize), static_cast<int64_t>(descSize)));
        NN_RESULT_SUCCESS;
    }

    void UnregisterProgram(uint64_t processId) NN_NOEXCEPT
    {
        nn::sf::SharedPointer<nn::fssrv::sf::IProgramRegistry> pProgramRegistry = detail::GetProgramRegistryServiceObject();
        NN_ABORT_UNLESS_RESULT_SUCCESS(pProgramRegistry->SetCurrentProcess(0));
        NN_ABORT_UNLESS_RESULT_SUCCESS(pProgramRegistry->UnregisterProgram(processId));
    }

    void SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT
    {
        nn::sf::SharedPointer<nn::fssrv::sf::IProgramRegistry> pProgramRegistry = detail::GetProgramRegistryServiceObject();
        NN_ABORT_UNLESS_RESULT_SUCCESS(pProgramRegistry->SetCurrentProcess(0));
        NN_ABORT_UNLESS_RESULT_SUCCESS(pProgramRegistry->SetEnabledProgramVerification(isEnabled));
    }

}}
