﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fsa/fs_IDirectory.h>

#include "fs_DirectoryAccessor.h"
#include "fs_FileSystemAccessor.h"

namespace nn { namespace fs { namespace detail {

    DirectoryAccessor::DirectoryAccessor(std::unique_ptr<fsa::IDirectory>&& directory, FileSystemAccessor& parent) NN_NOEXCEPT
        : m_Impl(std::move(directory)), m_Parent(parent)
    {
    }

    DirectoryAccessor::~DirectoryAccessor() NN_NOEXCEPT
    {
        m_Impl.reset();
        m_Parent.NotifyCloseDirectory(this);
    }

    Result DirectoryAccessor::Read(int64_t* outValue, DirectoryEntry* outEntries, int64_t count) NN_NOEXCEPT
    {
        return m_Impl->Read(outValue, outEntries, count);
    }

    Result DirectoryAccessor::GetEntryCount(int64_t* outValue) NN_NOEXCEPT
    {
        return m_Impl->GetEntryCount(outValue);
    }
}}}
