﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <cstdio>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_Result.h>
#include <nn/fssystem/fs_IStorage.h>
#include <nn/fat/fat_FatFileSystem.h>

using namespace nn::fs;
using namespace nn::fs::detail;
using namespace nn::fssystem;

namespace nn { namespace fat {


namespace {

    // TORIAEZU
    const int FatCachePageSize = 4;
    const int FatCachePageCount = 2;
    const int DataCachePageSize = 1;
    const int DataCachePageCount = 64;

    const int PfCachePageSize = 40;
    const int PfSectorBufSize = 512;

    const char AbortMessage[] = "FatFileSystem: dummy implementation. $SIGLO_ROOT/Externals/prfile2 is required. \n";

}

    void SetCurrentCalendarTimeGetter(FatCalendarTimeGetter currentCalendarTimeGetter)
    {
        NN_UNUSED(currentCalendarTimeGetter);
    }

    class FatFileSystem::DriveHandle : public Newable
    {
    };

    class FatFileSystem::FatSafeContext : public Newable
    {
    };

    size_t FatFileSystem::GetCacheBufferSize() NN_NOEXCEPT
    {
        size_t cacheCount = FatCachePageSize * FatCachePageCount + DataCachePageSize * DataCachePageCount;
        return PfCachePageSize * cacheCount + PfSectorBufSize * cacheCount;
    }

    FatFileSystem::FatFileSystem() NN_NOEXCEPT
        : m_Mutex(false)
    {
    }

    FatFileSystem::~FatFileSystem() NN_NOEXCEPT
    {
    }

    Result FatFileSystem::Initialize(nn::fs::IStorage* pBaseStorage, void* cacheBuffer, size_t cacheBufferSize) NN_NOEXCEPT
    {
        NN_UNUSED(pBaseStorage);
        NN_UNUSED(cacheBuffer);
        NN_UNUSED(cacheBufferSize);
        return ResultNotImplemented();
    }

    Result FatFileSystem::Initialize(std::shared_ptr<nn::fs::IStorage> pBaseStorage, void* cacheBuffer, size_t cacheBufferSize) NN_NOEXCEPT
    {
        NN_UNUSED(pBaseStorage);
        NN_UNUSED(cacheBuffer);
        NN_UNUSED(cacheBufferSize);
        return ResultNotImplemented();
    }

    Result FatFileSystem::Initialize(nn::fs::IStorage* pBaseStorage, void* cacheBuffer, size_t cacheBufferSize, FatAttribute* pFatAttribute, Result resultInvalidFatFormat, std::unique_ptr<nn::fat::FatErrorInfoSetter>&& pFatErrorInfoSetter) NN_NOEXCEPT
    {
        NN_UNUSED(pBaseStorage);
        NN_UNUSED(cacheBuffer);
        NN_UNUSED(cacheBufferSize);
        NN_UNUSED(pFatAttribute);
        NN_UNUSED(resultInvalidFatFormat);
        NN_UNUSED(pFatErrorInfoSetter);
        return ResultNotImplemented();
    }

    Result FatFileSystem::Initialize(std::shared_ptr<nn::fs::IStorage> pBaseStorage, void* cacheBuffer, size_t cacheBufferSize, FatAttribute* pFatAttribute, Result resultInvalidFatFormat, std::unique_ptr<nn::fat::FatErrorInfoSetter>&& pFatErrorInfoSetter) NN_NOEXCEPT
    {
        NN_UNUSED(pBaseStorage);
        NN_UNUSED(cacheBuffer);
        NN_UNUSED(cacheBufferSize);
        NN_UNUSED(pFatAttribute);
        NN_UNUSED(resultInvalidFatFormat);
        NN_UNUSED(pFatErrorInfoSetter);
        return ResultNotImplemented();
    }

    Result FatFileSystem::ResolvePath(char* outPath, size_t size, const char* path) const NN_NOEXCEPT
    {
        NN_UNUSED(outPath);
        NN_UNUSED(size);
        NN_UNUSED(path);
        NN_RESULT_SUCCESS;
    }

    Result FatFileSystem::Format() NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    Result FatFileSystem::Format(FatFormatParam* pFatFormatParam) NN_NOEXCEPT
    {
        NN_UNUSED(pFatFormatParam);
        NN_RESULT_SUCCESS;
    }

    bool FatFileSystem::IsExFatSupported() NN_NOEXCEPT
    {
        return false;
    }

    Result FatFileSystem::DoFlush() NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    Result FatFileSystem::Mount() NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    Result FatFileSystem::DoGetEntryType(DirectoryEntryType* outValue, const char *path) NN_NOEXCEPT
    {
        NN_UNUSED(outValue);
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoGetFreeSpaceSize(int64_t* outValue, const char *path) NN_NOEXCEPT
    {
        NN_UNUSED(outValue);
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoGetTotalSpaceSize(int64_t* outValue, const char *path) NN_NOEXCEPT
    {
        NN_UNUSED(outValue);
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::GetEntryTimeStamp(nn::fs::FileTimeStampRaw* outTimeStamp, const char* pFullPath) NN_NOEXCEPT
    {
        NN_UNUSED(outTimeStamp);
        NN_UNUSED(pFullPath);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoGetFileTimeStampRaw(nn::fs::FileTimeStampRaw* outTimeStamp, const char* path) NN_NOEXCEPT
    {
        NN_UNUSED(outTimeStamp);
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoOpenFile(std::unique_ptr<fsa::IFile>* outValue, const char* path, OpenMode mode) NN_NOEXCEPT
    {
        NN_UNUSED(outValue);
        NN_UNUSED(path);
        NN_UNUSED(mode);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoOpenDirectory(std::unique_ptr<fsa::IDirectory>* outValue, const char* path, OpenDirectoryMode mode) NN_NOEXCEPT
    {
        NN_UNUSED(outValue);
        NN_UNUSED(path);
        NN_UNUSED(mode);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoCreateFile(const char *path, int64_t size, int option) NN_NOEXCEPT
    {
        NN_UNUSED(path);
        NN_UNUSED(size);
        NN_UNUSED(option);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoDeleteFile(const char *path) NN_NOEXCEPT
    {
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::CreateDirectory(const char *path, int attribute) NN_NOEXCEPT
    {
        NN_UNUSED(path);
        NN_UNUSED(attribute);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoCreateDirectory(const char *path) NN_NOEXCEPT
    {
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoDeleteDirectory(const char *path) NN_NOEXCEPT
    {
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoDeleteDirectoryRecursively(const char *path) NN_NOEXCEPT
    {
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoCleanDirectoryRecursively(const char* path) NN_NOEXCEPT
    {
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoRenameFile(const char *currentPath, const char *newPath) NN_NOEXCEPT
    {
        NN_UNUSED(currentPath);
        NN_UNUSED(newPath);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoRenameDirectory(const char *currentPath, const char *newPath) NN_NOEXCEPT
    {
        NN_UNUSED(currentPath);
        NN_UNUSED(newPath);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::DoCommit() NN_NOEXCEPT
    {
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::GetAttribute(int* outValue, const char *path) NN_NOEXCEPT
    {
        NN_UNUSED(outValue);
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    Result FatFileSystem::GetFileSize(int64_t* outValue, const char *path) NN_NOEXCEPT
    {
        NN_UNUSED(outValue);
        NN_UNUSED(path);
        NN_ABORT(AbortMessage);
    }

    void FatFileSystem::SetAllocatorForFatSafe(nn::MemoryResource* pMemoryResource) NN_NOEXCEPT
    {
        NN_UNUSED(pMemoryResource);
    }

}}
