﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <nn/dt/server/dt_Server.h>

#include "dt_FdtManager.h"
#include "dt_ServiceName.h"
#include "dt_DeviceTreeInterface.h"

namespace nn { namespace dt { namespace server {


namespace {
    const int MaxSessionCount = 16; // TORIEAZU
    const int MaxPortCount = 1;

    class DeviceTreeServerManager : public nn::sf::HipcSimpleAllInOneServerManager<MaxSessionCount, MaxPortCount>
    {
    };

    DeviceTreeServerManager g_ServerManager;

    nn::sf::UnmanagedServiceObject<nn::dt::detail::IDeviceTree, nn::dt::server::DeviceTreeInterface> g_ServiceObject;
}

void Initialize() NN_NOEXCEPT
{
    GetFdtManager()->Initialize(nullptr, 0);
}

void InitializeForDebug(const nn::Bit8* fdt, size_t size) NN_NOEXCEPT
{
    GetFdtManager()->Initialize(fdt, size);
}

nn::sf::SharedPointer<nn::dt::detail::IDeviceTree> GetServiceObject() NN_NOEXCEPT
{
    return g_ServiceObject.GetShared();
}

void RegisterHipcServer() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServerManager.RegisterObjectForPort(g_ServiceObject.GetShared(), MaxSessionCount, DeviceTreeServiceName));
}

void StartHipcServer() NN_NOEXCEPT
{
    g_ServerManager.Start();
}

void LoopHipcServer() NN_NOEXCEPT
{
    g_ServerManager.LoopAuto();
}

}}}  // namespace nn::dt
