﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnc/nn_Common.h>
#include <nnc/result/result_CConverter.h>
#include <nnc/dt/dt_RegisterApi.h>
#include <nn/dt.h>

extern "C"
{

nnResult nndtGetRegisterAddressInt32(int32_t * pOutAddress, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterAddress<int32_t>(
        pOutAddress, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterAddressInt64(int64_t * pOutAddress, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterAddress<int64_t>(
        pOutAddress, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterAddressArrayInt32(int32_t * pOutArray, int count, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterAddressArray<int32_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterAddressArrayInt64(int64_t * pOutArray, int count, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterAddressArray<int64_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterAddressListInt32(int32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterAddressList<int32_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterAddressListInt64(int64_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterAddressList<int64_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterSizeInt32(int32_t * pOutSize, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterSize<int32_t>(
        pOutSize, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterSizeInt64(int64_t * pOutSize, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterSize<int64_t>(
        pOutSize, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterSizeArrayInt32(int32_t * pOutArray, int count, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterSizeArray<int32_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterSizeArrayInt64(int64_t * pOutArray, int count, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterSizeArray<int64_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterSizeListInt32(int32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterSizeList<int32_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetRegisterSizeListInt64(int64_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterSizeList<int64_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

}
