﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnc/nn_Common.h>
#include <nnc/result/result_CConverter.h>
#include <nnc/dt/dt_PropertyApi.h>
#include <nn/dt.h>

extern "C"
{

nnResult nndtGetPropertyInt8(int8_t * pOutValue, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetProperty<int8_t>(
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyUInt8(uint8_t * pOutValue, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetProperty<uint8_t>(
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyInt16(int16_t * pOutValue, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetProperty<int16_t>(
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyUInt16(uint16_t * pOutValue, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetProperty<uint16_t>(
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyInt32(int32_t * pOutValue, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetProperty<int32_t>(
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyUInt32(uint32_t * pOutValue, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetProperty<uint32_t>(
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyInt64(int64_t * pOutValue, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetProperty<int64_t>(
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyUInt64(uint64_t * pOutValue, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetProperty<uint64_t>(
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyArrayInt8(int8_t * pOutArray, int count, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyArray<int8_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyArrayUInt8(uint8_t * pOutArray, int count, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyArray<uint8_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyArrayInt16(int16_t * pOutArray, int count, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyArray<int16_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyArrayUInt16(uint16_t * pOutArray, int count, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyArray<uint16_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyArrayInt32(int32_t * pOutArray, int count, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyArray<int32_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyArrayUInt32(uint32_t * pOutArray, int count, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyArray<uint32_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyArrayInt64(int64_t * pOutArray, int count, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyArray<int64_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyArrayUInt64(uint64_t * pOutArray, int count, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyArray<uint64_t>(
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyListInt8(int8_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyList<int8_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyListUInt8(uint8_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyList<uint8_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyListInt16(int16_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyList<int16_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyListUInt16(uint16_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyList<uint16_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyListInt32(int32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyList<int32_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyListUInt32(uint32_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyList<uint32_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyListInt64(int64_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyList<int64_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertyListUInt64(uint64_t * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyList<uint64_t>(
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

}
