﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/drivers/eth/driverEth.h>
#include "eth_EthernetDriver.h"

namespace
{
    nn::drivers::eth::EthernetDriver s_EthernetDriver;
}


namespace nn { namespace drivers { namespace eth {

nn::Result Initialize()
{
    return s_EthernetDriver.Initialize();
}

nn::Result Finalize()
{
    return s_EthernetDriver.Finalize();
}

void RegisterFrameReceivedCallBack(FrameReceivedCallBack callBack)
{
    s_EthernetDriver.RegisterFrameReceivedCallBack(callBack);
}
void UnregisterFrameReceivedCallBack()
{
    s_EthernetDriver.UnregisterFrameReceivedCallBack();
}

void RegisterSendCompletedCallBack(SendCompletedCallBack callBack)
{
    s_EthernetDriver.RegisterSendCompletedCallBack(callBack);
}

void UnregisterSendCompletedCallBack()
{
    s_EthernetDriver.UnregisterSendCompletedCallBack();
}

nn::Result GetMacAddress(uint8_t pMacAddress[NN_NET_MAC_ADDRESS_SIZE])
{
    return s_EthernetDriver.GetMacAddress(pMacAddress);
}

nn::Result Send(const void* frameData, int frameBytes)
{
    return s_EthernetDriver.Send(frameData, frameBytes);
}

nn::Result Send(nnnetOslMbuf* pMbuf)
{
    return s_EthernetDriver.Send(pMbuf);
}

nn::Result Send(int32_t numSegments, uint8_t **segmentBuffers, size_t *segmentSizes)
{
    return s_EthernetDriver.Send(numSegments, segmentBuffers, segmentSizes);
}

void RegisterInterfaceStateCallBack(InterfaceStateCallBack callback)
{
    return s_EthernetDriver.RegisterInterfaceStateCallBack(callback);
}

void UnregisterInterfaceStateCallBack()
{
    return s_EthernetDriver.UnregisterInterfaceStateCallBack();
}

}}}

