﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   ログ出力APIの実装に利用する非公開グローバル変数の宣言
*/

#include <nn/nn_Common.h>

namespace nn { namespace diag {

struct LogObserverHolder;

namespace detail {

    // VPrintf, Printf が内部で使用するバッファサイズです。
    const size_t DebugPrintfBufferLength = 128u;

    // ログオブザーバのリンクリストの先頭
    extern LogObserverHolder* g_LogObserverListHead;

}

/**
*   @brief      ログのメタ情報です。
*
*   @deprecated 廃止予定です。代わりに LogMetaData を使用してください。
*/
struct LogMetaInfo
{
    const char* fileName;       //!<    ソースコードのファイル名
    int lineNumber;             //!<    ソースコード内での行番号
};

}}

