﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/diag/detail/diag_DetailLog.h>
#include <nnc/diag/detail/diag_DetailLog.h>
#include <cstdarg>
#include "diag_LogImpl.h"

extern "C" {

void nndetailDiagVLogImpl(const char* fileName, int lineNumber, const char* format, va_list args) NN_NOEXCEPT
{
    nndiagLogMetaData logMetaData;
    logMetaData.sourceInfo.lineNumber = lineNumber;
    logMetaData.sourceInfo.fileName = fileName;
    logMetaData.sourceInfo.functionName = "";
    logMetaData.moduleName = "";
    logMetaData.severity = nndiagLogSeverity_Info;
    logMetaData.verbosity = 0;
    logMetaData.useDefaultLocaleCharset = false;
    logMetaData.pAdditionalData = NULL;
    logMetaData.additionalDataBytes = 0;

    nndetailDiagVLogImplForC(&logMetaData, format, args);
}

void nndetailDiagLogImpl(const char* fileName, int lineNumber, const char* format, ...) NN_NOEXCEPT
{
    va_list list;
    va_start(list, format);
    nndetailDiagVLogImpl(fileName, lineNumber, format, list);
    va_end(list);
}

void nndetailDiagVLogImplForC(const nndiagLogMetaData* pLogMetaData, const char* format, va_list args)
{
    nn::diag::detail::VLogImpl(*reinterpret_cast<const nn::diag::LogMetaData*>(pLogMetaData), format, args);
}

void nndetailDiagLogImplForC(const nndiagLogMetaData* pLogMetaData, const char* format, ...)
{
    va_list list;
    va_start(list, format);
    nndetailDiagVLogImplForC(pLogMetaData, format, list);
    va_end(list);
}

void nndetailDiagPutImplForC(const nndiagLogMetaData* pLogMetaData, const char* text, size_t length)
{
    nn::diag::detail::PutImpl(*reinterpret_cast<const nn::diag::LogMetaData*>(pLogMetaData), text, length);
}

} // extern "C"
