﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/diag/diag_AbortTypes.h>
#include <nn/diag/diag_AbortObserver.h>
#include "detail/diag_AbortObserverManager.h"

namespace nn { namespace diag {

namespace detail {

bool g_EnableDefaultAbortObserver = true;

} // detail

namespace {
    template<typename ObserverHolderType, typename ObserverType>
    void InitializeAbortObserverHolderImpl(ObserverHolderType* abortObserverHolder, ObserverType abortObserver) NN_NOEXCEPT
    {
        abortObserverHolder->observer = abortObserver;
        abortObserverHolder->next = nullptr;
        abortObserverHolder->isRegistered = false;
    }
}

// --------------------------------------

void InitializeAbortObserverHolder(
    AbortObserverHolder* abortObserverHolder,
    AbortObserver abortObserver) NN_NOEXCEPT
{
    InitializeAbortObserverHolderImpl(abortObserverHolder, abortObserver);
}

void RegisterAbortObserver(
    AbortObserverHolder* abortObserverHolder) NN_NOEXCEPT
{
    detail::GetAbortObserverManager()->RegisterObserver(abortObserverHolder);
}

void UnregisterAbortObserver(
    AbortObserverHolder* abortObserverHolder) NN_NOEXCEPT
{
    detail::GetAbortObserverManager()->UnregisterObserver(abortObserverHolder);
}

void EnableDefaultAbortObserver(bool enable) NN_NOEXCEPT
{
    detail::g_EnableDefaultAbortObserver = enable;
}

// --------------------------------------
void InitializeSdkAbortObserverHolder(
    SdkAbortObserverHolder* abortObserverHolder,
    SdkAbortObserver abortObserver) NN_NOEXCEPT
{
    InitializeAbortObserverHolderImpl(abortObserverHolder, abortObserver);
}

void RegisterSdkAbortObserver(
    SdkAbortObserverHolder* abortObserverHolder) NN_NOEXCEPT
{
    detail::GetSdkAbortObserverManager()->RegisterObserver(abortObserverHolder);
}

void UnregisterSdkAbortObserver(
    SdkAbortObserverHolder* abortObserverHolder) NN_NOEXCEPT
{
    detail::GetSdkAbortObserverManager()->UnregisterObserver(abortObserverHolder);
}


}} // nn::diag
