﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdarg>
#include <mutex>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/cstd/cstd_CStdArg.h>
#include <nn/nn_Result.h>
#include <nn/diag/diag_AbortTypes.h>
#include <nn/diag/diag_AbortTypesForSystem.h>
#include <nn/diag/diag_LogTypes.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/os/os_UserExceptionHandlerTypes.h>
#include "detail/diag_Abort.h"

namespace nn { namespace diag { namespace detail {

namespace
{
    nn::os::SdkMutexType g_Mutex = NN_OS_SDK_MUTEX_INITIALIZER();
}

NN_NORETURN void VAbortImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const Result* result,
    const nn::os::UserExceptionInfo* exceptionInfo,
    const char* format,
    std::va_list formatArgs) NN_NOEXCEPT
{
    if (g_Mutex.IsLockedByCurrentThread())
    {
        detail::Abort(result);
    }
    std::lock_guard<decltype (g_Mutex)> lock(g_Mutex);

    const nn::diag::LogMessage message = {format, &formatArgs};
    const AbortInfo abortInfo = {
        AbortReason_Abort,
        &message,
        condition,
        functionName,
        fileName,
        lineNumber
    };
    const SdkAbortInfo sdkAbortInfo = {
        abortInfo,
        *result,
        exceptionInfo,
    };

    InvokeAbortObserver(abortInfo);
    InvokeSdkAbortObserver(sdkAbortInfo);

    detail::Abort(result);
}

NN_NORETURN void AbortImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const Result* result,
    const nn::os::UserExceptionInfo* userExceptionInfo,
    const char* format,
    ...) NN_NOEXCEPT
{
    std::va_list list;
    va_start(list, format);
    VAbortImpl(condition, functionName, fileName, lineNumber, result, userExceptionInfo, format, list);
    //  C4702（制御がわたらないコード）のためコメントアウト
    //    va_end(list);
}

NN_NORETURN void AbortImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const Result* result,
    const char* format,
    ...) NN_NOEXCEPT
{
    std::va_list list;
    va_start(list, format);
    VAbortImpl(condition, functionName, fileName, lineNumber, result, nullptr, format, list);
//  C4702（制御がわたらないコード）のためコメントアウト
//    va_end(list);
}


NN_NORETURN void AbortImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const char* format,
    ...) NN_NOEXCEPT
{
    Result result = ResultSuccess();
    std::va_list list;
    va_start(list, format);
    VAbortImpl(condition, functionName, fileName, lineNumber, &result, nullptr, format, list);
//  C4702（制御がわたらないコード）のためコメントアウト
//    va_end(list);
}


NN_NORETURN void AbortImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber) NN_NOEXCEPT
{
    Result result = ResultSuccess();
    detail::AbortImpl(condition, functionName, fileName, lineNumber, &result, "");
}

}}} // nn::diag::detail
