﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <unwind.h>
#include <nn/nn_Common.h>

namespace nn { namespace diag { namespace detail {

extern "C" {

void __gnu_Unwind_Backtrace(_Unwind_Trace_Fn pTrace, void* pArg, void* pInfo);

// pInfo を構築し、__gnu_Unwind_Backtrace() を呼び出す
void nndetailDiagCallUnwindBacktrace(_Unwind_Trace_Fn pTrace, void* pArg);

} //extern "C"

namespace {

struct TraceInfo
{
    uintptr_t   *pArray;
    int         arrayCount;
    int         arrayCountMax;
};

_Unwind_Reason_Code TraceFunction(_Unwind_Context* pContext, void* pArg) NN_NOEXCEPT
{
    void *ip = reinterpret_cast<void *>(_Unwind_GetIP(pContext));

    TraceInfo *pTraceInfo = static_cast<TraceInfo*>(pArg);
    if (pTraceInfo->arrayCount < pTraceInfo->arrayCountMax)
    {
        *pTraceInfo->pArray++ = reinterpret_cast<uintptr_t>(ip);
        pTraceInfo->arrayCount++;
    }

    if (ip == nullptr)
    {
        return _URC_END_OF_STACK;
    }
    else
    {
        return _URC_NO_REASON;
    }
}

} // anonymous

int GetBacktraceImpl(uintptr_t *pOutArray, int arrayCountMax) NN_NOEXCEPT
{
    TraceInfo traceInfo = {pOutArray, 0, arrayCountMax};

    nndetailDiagCallUnwindBacktrace(&TraceFunction, &traceInfo);

    return traceInfo.arrayCount;
}

}}} // nn::diag::detail
