﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/util/util_ScopeExit.h>

#include <nn/ddsf/ddsf_ISession.h>
#include <nn/ddsf/ddsf_IDevice.h>
#include <nn/ddsf/ddsf_IDriver.h>
#include <nn/ddsf/detail/ddsf_CastSafe.h>
#include <nn/ddsf/detail/ddsf_Log.h>

NN_DETAIL_DDSF_CAST_SAFE_DEFINE_ROOT(nn::ddsf::ISession);
NN_DETAIL_DDSF_CAST_SAFE_DEFINE_ROOT(nn::ddsf::IDevice);
NN_DETAIL_DDSF_CAST_SAFE_DEFINE_ROOT(nn::ddsf::IDriver);

namespace nn { namespace ddsf {

// TODO: IDevice& ではなく DeviceCode を引数に取るバージョン（この場合 DeviceCodeEntry のリストの注入も必要）

nn::Result OpenSession(IDevice* pDevice, ISession* pSession, AccessMode accessMode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pDevice);
    NN_SDK_REQUIRES_NOT_NULL(pSession);
    NN_SDK_REQUIRES(!pSession->IsOpen());
    bool needsRollback = true;

    // - 1. アクセス許可のチェックなど (未実装)
    // - 2. セッションにデバイスを紐づけ
    // - 3. デバイスのセッションリストにこのセッションを追加
    //   - セッションリストをいつ foreach されても良いよう、このセッションリストの追加は最後に行う

    pSession->AttachDevice(pDevice, accessMode);
    NN_UTIL_SCOPE_EXIT
    {
        if ( needsRollback )
        {
            pSession->DetachDevice();
        }
    };

    pDevice->AttachSession(pSession);
    NN_UTIL_SCOPE_EXIT
    {
        if ( needsRollback )
        {
            pDevice->DetachSession(pSession);
        }
    };

    needsRollback = false; // 成功
    NN_RESULT_SUCCESS;
}

void CloseSession(ISession* pSession) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pSession);

    // パッドオブジェクトとセッションの紐づけ解除
    // Open の逆順
    pSession->GetDevice().DetachSession(pSession);
    pSession->DetachDevice();
}

}} // nn::ddsf
