﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Standard Definitions
 *
 * @details
 */

#pragma once

namespace nn { namespace bsdsocket { namespace dhcpc {



// Constants taken from RFC 2131
enum RetransmitBackoff
{
    RetransmitBackoff_BaseMin     = 4,
    RetransmitBackoff_BaseMax     = 64,
    RenewRebindRetransmit_BaseMin = 60,
    RetransmitBackoff_RandomMin   = -1,
    RetransmitBackoff_RandomMax   = 1,
};
// Time In Milliseconds
enum StartupWaitTime
{
    StartupWaitTime_RandomMin = 1,  // this time changed from standard of 1 second for shorter dhcp init times
    StartupWaitTime_RandomMax = 400 // this time changed from standard of 10 seconds for shorter dhcp init times
};

enum NakBackoff
{
    NakBackoff_Max  = 60,
};

enum DhcpSizes
{
    DhcpSizes_MtuMax     = 1500,
    DhcpSizes_Chaddr     = 16,
    DhcpSizes_ServerName = 64,
    DhcpSizes_Bootfile   = 128,
    DhcpSizes_Udp        = 14 + 20 + 8,
    DhcpSizes_Fixed      = DhcpSizes_Udp + 226,
    DhcpSizes_Option     = DhcpSizes_MtuMax - DhcpSizes_Fixed,
};

enum DhcpMessageFlags
{
    DhcpProtMessageFlags_Broadcast  = 0x8000,
    DhcpMessageFlags_MagicCookie    = 0x63825363,
};


struct DhcpMessage {
    uint8_t  op;                               //  message type
    uint8_t  hwtype;                           //  hardware address type
    uint8_t  hwlen;                            //  hardware address length
    uint8_t  hwopcount;                        //  should be zero in client message
    uint32_t xid;                              //  transaction id
    uint16_t secs;                             //  elapsed time in sec. from boot
    uint16_t flags;
    uint32_t ciaddr;                           // (previously allocated) client IP
    uint32_t yiaddr;                           //  'your' client IP address
    uint32_t siaddr;                           //  should be zero in client's messages
    uint32_t giaddr;                           //  should be zero in client's messages
    uint8_t  chaddr[DhcpSizes_Chaddr];         //  client's hardware address
    uint8_t  servername[DhcpSizes_ServerName]; //  server host name
    uint8_t  bootfile[DhcpSizes_Bootfile];     //  boot file name
    uint32_t cookie;
    uint8_t  options[DhcpSizes_Option];        // message options - cookie
} __packed;



} // namespace dhcpc
} // namespace bsdsocket
} // namespace nn


