﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief Descriptor monitor
 *
 * @details
 */

namespace nn { namespace bsdsocket { namespace dhcpc {


class DhcpcMain;
struct LocalEventType;

class FdMonitor
{
public:
    static const int32_t   FastPollPeriod = 50;
    static const int32_t   SlowPollPeriod = 1000;

    FdMonitor();
    ~FdMonitor();
    Result Initialize(DhcpcMain *pMain);
    Result Finalize();
    Result Register(int fd,
                    LocalEventPoolType *pLocalEventPool,
                    int32_t eventId);
    Result Register(int fd, void (*callback)(void *pContext),
                    void *pContext);
    Result UnRegister(int fd);
    Result SetPollPeriod(int fd, int periodMs);

private:
    static const int32_t   MaxPolledEvent = 8;

    enum UserRegistrationMode
    {
        UserRegistrationMode_Invalid=0,
        UserRegistrationMode_Event,
        UserRegistrationMode_Callback
    };

    struct UserRegistrationType
    {
        bool                  active;
        struct pollfd         polledFd;
        UserRegistrationMode  mode;
        int                   pollPeriodMs;
        union
        {
            struct
            {
                void                *pContext;
                void (*callback)(void *pContext);
            }callback;
            struct
            {
                LocalEventPoolType  *pLocalEventPool;
                int32_t             eventId;
            }event;
        }cfg;
    };


    void Poll();
    void UpdatePollTimer();
    void LocalEventCallback(LocalEventType *pEvent);
    static void LocalEventCallbackStatic(void *context, LocalEventType *pEvent)
    {
        FdMonitor *pFdMon = static_cast<FdMonitor *>(context);
        pFdMon->LocalEventCallback(pEvent);
    }

    DhcpcMain               *m_pMain;
    LocalEventType          *m_pTimerEvent;
    UserRegistrationType    m_Registrations[MaxPolledEvent];
    LocalEventPoolType      m_LocalEventPool;
    LocalEventType          m_LocalEventStorage[8];
};

} // namespace dhcpc
} // namespace bsdsocket
} // namespace nn

