﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/nn_Common.h>
#include "../kern_Platform.h"
#include "../kern_Kernel.h"
#include "../kern_HardwareTimerSelect.h"
#include "kern_SvcHandlers.h"

namespace nn { namespace kern { namespace svc {
namespace {
/*!
    @brief チック数を取得します。

    @return チック数
*/
int64_t SvcGetSystemTick()
{
    return KHardwareTimer::GetTick();
}
}

#if defined(NN_BUILD_CONFIG_CPU_SVC_32)
int64_t SvcGetSystemTick32()
{
    int64_t ticks = SvcGetSystemTick();
    ClearSvcOutRegistersReturnInt64();
    return ticks;
}
#endif

#if defined(NN_BUILD_CONFIG_CPU_SVC_64)
int64_t SvcGetSystemTick64()
{
    int64_t ticks = SvcGetSystemTick();
    ClearSvcOutRegistersReturnInt64();
    return ticks;
}
#endif

#if defined(NN_BUILD_CONFIG_CPU_SVC_64FROM32)
int64_t SvcGetSystemTick64From32()
{
    int64_t ticks = SvcGetSystemTick();
    ClearSvcOutRegistersReturnInt64();
    return ticks;
}
#endif // #if defined(NN_BUILD_CONFIG_CPU_SVC_64FROM32)
}}}
