﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include "kern_Platform.h"
#include "kern_Uncompress.h"

namespace nn {
namespace kern {
// アーキテクチャに依存しない(はず)のバリアント
const int LZ_BIT_INDEX          = 12;    // 12bit offset
const int LZ_BIT_LENGTH         =  4;    //  4bit length
const int LZ_MAX_INDEX          = (1 << LZ_BIT_INDEX);
const int LZ_MAX_LENGTH         = (1 << LZ_BIT_LENGTH);
const int LZ_MIN_COPY           = 3;
void UncompressBackward(void* pBottom)
{
    uint8_t* pBufferBottom = static_cast<uint8_t*>(pBottom);
    uint32_t bufferTopOffset =
        (pBufferBottom[-9] << 24) |
        (pBufferBottom[-10] << 16) |
        (pBufferBottom[-11] << 8)  |
        pBufferBottom[-12];
    uint32_t compressBottomOffset =
        (pBufferBottom[-5] << 24) |
        (pBufferBottom[-6] << 16) |
        (pBufferBottom[-7] << 8)  |
        pBufferBottom[-8];
    uint32_t originalBottomOffset =
        (pBufferBottom[-1] << 24) |
        (pBufferBottom[-2] << 16) |
        (pBufferBottom[-3] << 8)  |
        pBufferBottom[-4];
    uint8_t* bufferTop = pBufferBottom - bufferTopOffset;
    uint8_t* compressBottom = pBufferBottom - compressBottomOffset;
    uint8_t* originalBottom = pBufferBottom + originalBottomOffset;
    uint32_t orignalSize = originalBottom - bufferTop;
    uint32_t compressSize = compressBottom - bufferTop;

    while (orignalSize != 0)
    {
        uint32_t flag = bufferTop[--compressSize];

        for (uint32_t j = 0; j < 8; j++)
        {
            if (flag & 0x80) // 圧縮データか？
            {
                uint16_t half;
                uint32_t len;
                uint32_t index;
                uint32_t i;

                // 展開長を計算
                compressSize -= 2;
                half = bufferTop[compressSize] | (bufferTop[compressSize + 1] << 8);
                len = ((half >> LZ_BIT_INDEX) & (LZ_MAX_LENGTH - 1)) + LZ_MIN_COPY;
                index = (half & (LZ_MAX_INDEX - 1)) + LZ_MIN_COPY;
                if (orignalSize < len)
                {
                    len = orignalSize;
                }
                orignalSize -= len;

                for (i = 0; i < len; i++)
                {
                    bufferTop[orignalSize + i] = bufferTop[orignalSize + index + i];
                }
            }
            else
            {
                bufferTop[--orignalSize] = bufferTop[--compressSize];
            }
            flag <<= 1;
            if (orignalSize == 0)
            {
                return;
            }
        }
    }
}
} // end of namespace kern
} // end of namespace nn

