﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include "kern_Platform.h"
#include "kern_KUseSlabAllocator.h"
#include "kern_KObjectName.h"
#include "kern_DebugSelect.h"
#include "kern_KPageGroup.h"
#include "kern_KProcess.h"
#include "kern_KSessionRequest.h"
#include "kern_KSharedMemoryInfo.h"
#include "kern_KPageBuffer.h"
#include "kern_KInterruptEvent.h"

namespace nn { namespace kern {

    template <class T> KSlabAllocator<T> KUseSlabAllocator<T>::s_SlabAllocator;

    template class KUseSlabAllocator<KObjectName>;
#if NN_KERN_HAS_MMU
    template class KUseSlabAllocator<KThreadLocalPage>;
#endif
    template class KUseSlabAllocator<KEventInfo>;
    template class KUseSlabAllocator<KSessionRequest>;
    template class KUseSlabAllocator<KSharedMemoryInfo>;
    template class KUseSlabAllocator<KPageBuffer>;
    template class KUseSlabAllocator<KInterruptEventTask>;
}}
