﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_Assert.h"
#include "kern_Kernel.h"
#include "kern_KSpinLockMutex.h"
#include "kern_KScheduler.h"
#include "kern_KThread.h"

namespace nn { namespace kern {

void KSpinLockMutex::Lock()
{
    NN_KERN_THIS_ASSERT();

    KThread* current = &GetCurrentThread();

    if (IsLockedByMe())
    {
        NN_KERN_MIN_ASSERT(m_Count, 1);
        ++m_Count;
    }
    else
    {
        KScheduler::DisableScheduling();

        m_Lock.Lock();

        NN_KERN_EQUAL_ASSERT(m_Count, 0);
        NN_KERN_ASSERT(m_pLockingThread == nullptr);
        m_Count++;
        m_pLockingThread = current;
    }
}


void KSpinLockMutex::Unlock()
{
    NN_KERN_THIS_ASSERT();
    NN_KERN_ASSERT(IsLockedByMe());
    NN_KERN_MIN_ASSERT(m_Count, 1);

    if (--m_Count == 0)
    {
        m_pLockingThread = nullptr;

        m_Lock.Unlock();

        KScheduler::EnableScheduling();
    }
}

void KSpinLockMutex::UnlockAndScheduleAll()
{
    NN_KERN_THIS_ASSERT();
    NN_KERN_ASSERT(IsLockedByMe());
    NN_KERN_MIN_ASSERT(m_Count, 1);

    if (--m_Count == 0)
    {
        KScheduler::UpdateHighestThreads();

        m_pLockingThread = nullptr;

        m_Lock.Unlock();

        KScheduler::EnableSchedulingAndScheduleAll();
    }
}

}}

