﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "kern_PageTableSelect.h"
#include "kern_KPageGroup.h"
#include "kern_KObjectAdaptor.h"

namespace nn { namespace kern {

class KProcess;
class KResourceLimit;
class KSharedMemory : public KObjectAdaptor<KSharedMemory, KAutoObjectWithList>
{
private:
    KPageGroup      m_Memory;
    KResourceLimit* m_pResourceLimit;
    Bit64           m_Pid;
    nn::svc::MemoryPermission m_OwnerProtection;
    nn::svc::MemoryPermission m_OtherProtection;
    bool            m_IsInitialized;

public:
    explicit KSharedMemory();
    virtual ~KSharedMemory();

    virtual void    Finalize();

    virtual bool IsInitialized() const { return m_IsInitialized; }
    static void  PostFinalize(uintptr_t arg) { NN_UNUSED(arg); }

    Result  Initialize(
                KProcess*           pOwner,
                size_t              size,
                nn::svc::MemoryPermission ownerProtection,
                nn::svc::MemoryPermission otherProtection );

    Result  Map(
                KProcessPageTable*  pTable,
                KProcessAddress     addr,
                size_t              size,
                KProcess*           pProcess,
                nn::svc::MemoryPermission myPermission );
    Result  Unmap(
                KProcessPageTable*  pTable,
                KProcessAddress     addr,
                size_t              size,
                KProcess*           pProcess );

    Bit64 GetOwnerId() const { return m_Pid; }

    size_t GetSize() const;
    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KSharedMemory, KAutoObject)
};

}}

