﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_KSessionRequest.h"
#include "kern_Kernel.h"
#include "kern_KResourceLimit.h"
#include "kern_KScopedResourceLimitTester.h"
#include "kern_KPageBuffer.h"

namespace nn { namespace kern {

NN_AUTOOBJECT_DEFINE_TYPE_NAME(KSessionRequest);


Result KSessionRequest::SessionMapData::PushMapData(int x, KProcessAddress client, KProcessAddress server, size_t size, KMemoryState state)
{
    MapData* pMapData;
    // map転送 の最大個数は 4bit x 3
    NN_KERN_ASSERT(x < ((1 << 4) * 3));
    if (x < NumMapDataStatic)
    {
        pMapData = &m_MapDataStatic[x];
    }
    else
    {
        if (m_pMapData == nullptr)
        {
            KPageBuffer* pPageBuffer = KPageBuffer::Allocate();
            if (!pPageBuffer)
            {
                return nn::svc::ResultOutOfMemory();
            }

            m_pMapData = reinterpret_cast<MapData*>(pPageBuffer);
        }
        pMapData = &m_pMapData[x - NumMapDataStatic];
    }
    pMapData->Set(client, server, size, state);

    return ResultSuccess();
}

Result KSessionRequest::SessionMapData::PushSend(KProcessAddress client, KProcessAddress server, size_t size, KMemoryState state)
{
    NN_KERN_ASSERT(m_ReceiveNum == 0);
    NN_KERN_ASSERT(m_ExchangeNum == 0);
    return PushMapData(m_SendNum++, client, server, size, state);
}

Result KSessionRequest::SessionMapData::PushReceive(KProcessAddress client, KProcessAddress server, size_t size, KMemoryState state)
{
    NN_KERN_ASSERT(m_ExchangeNum == 0);
    return PushMapData(m_SendNum + m_ReceiveNum++, client, server, size, state);
}

Result KSessionRequest::SessionMapData::PushExchange(KProcessAddress client, KProcessAddress server, size_t size, KMemoryState state)
{
    return PushMapData(m_SendNum + m_ReceiveNum + m_ExchangeNum++, client, server, size, state);
}

void KSessionRequest::SessionMapData::Finalize()
{
    if (m_pMapData)
    {
        KPageBuffer::Free(reinterpret_cast<KPageBuffer*>(m_pMapData));
        m_pMapData = nullptr;
    }
}

}}
