﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>
#include "kern_KSynchronizationObject.h"
#include "kern_KThread.h"
#include "kern_KThreadQueue.h"

namespace nn { namespace kern {

class KLightSession;

class KLightServerSession :
    public KObjectAdaptor<KLightServerSession, KAutoObjectWithList>,
    public nn::util::IntrusiveListBaseNode<KLightServerSession>
{
private:
    KLightSession*          m_pParent;
    KThreadQueue            m_RequestQueue;
    KThreadQueue            m_ServerQueue;
    KThread*                m_pCurrentRequest;
    KThread*                m_pServerThread;

public:
    explicit    KLightServerSession()  : m_pCurrentRequest(nullptr), m_pServerThread(nullptr) {}
    virtual     ~KLightServerSession() {}

    void        Initialize(KLightSession* p)
    {
        NN_KERN_THIS_ASSERT();
        m_pParent = p;
    }

    virtual void    Destroy();
    static void     PostFinalize(uintptr_t arg) { NN_UNUSED(arg); }


    Result          OnRequest(KThread* pRequestSource);
    Result          ReplyAndReceive(Bit32* pData);

    //! クライアントセッションが閉じたことの通知
    void            OnClientClosed();
    void            CleanupRequest();

private:

    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KLightServerSession, KAutoObject)
};

}}

