﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*!
    @file

    @brief 割り込みハンドラに関する API の宣言

*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace kern {

class KInterruptTask;

/*!
    @brief     割り込みハンドラクラスの定義です。

*/
class KInterruptHandler
{
public:
    /*!
        @brief  割り込みハンドラ中での処理。

                ハンドラ中で行うことのみを記述します。

        @return カーネルタスクスレッドで行うタスクを返します。

                カーネルタスクスレッドで何もする必要がないときは、NULLを返します。
    */
    virtual KInterruptTask* OnInterrupt(int32_t interruptRequestNo) = 0;
};

}}

