﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>

namespace nn { namespace kern { namespace KDumpObject {

    void DumpThread();
    void DumpThread(Bit64 tid);

    void DumpThreadCallstack();
    void DumpThreadCallstack(Bit64 tid);

    void DumpProcess();
    void DumpProcess(Bit64 pid);

    void DumpHandle();
    void DumpHandle(Bit64 pid);

    void DumpKernelObject();

    void DumpKernelMemory();
    void DumpMemory();
    void DumpMemory(Bit64 pid);

    void DumpKernelPageTable();
    void DumpPageTable();
    void DumpPageTable(Bit64 pid);

    void DumpKernelCpuUtilization();
    void DumpCpuUtilization();
    void DumpCpuUtilization(Bit64 pid);

    void DumpPort(Bit64 pid);
    void DumpPort();

}}}

