﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_Assert.h"
#include "kern_Kernel.h"
#include "kern_KAutoObject.h"
#include "kern_KProcess.h"
#include "kern_HardwareTimerSelect.h"
#include "kern_DebugString.h"
#include "kern_KScheduler.h"

namespace nn { namespace kern {

NN_AUTOOBJECT_DEFINE_TYPE_NAME(KAutoObject);

/*
    @brief      AutoObject の初期化処理

    @return     参照カウントが 1 になった状態のオブジェクトを返します。

*/
KAutoObject* KAutoObject::Create(KAutoObject* pObj)
{
    NN_KERN_POINTER_ASSERT(pObj);
    // 初期参照カウントは1
    pObj->m_ReferenceCount = 1;

#if NN_KERN_ENABLE_OBJECT_INFO
    KProcess* p = GetCurrentProcessPointer();
    pObj->m_ParentId = (p != NULL) ? p->GetId(): 0;

//    int64_t tick = Kernel::GetHardwareTimer().GetTick();
//    pObj->m_CreationTimeLo = static_cast<uint32_t>(tick);
//    pObj->m_CreationTimeHi = static_cast<uint32_t>(tick >> 32);
#endif

    return pObj;
}

/*
    @brief      内部状態を表示します。

*/
void KAutoObject::Show()
{
    NN_KERN_THIS_ASSERT();
}

bool KAutoObject::CanClose()
{
    return Kernel::GetState() != Kernel::STATE_NORMAL || KScheduler::CanSchedule();
}

}}

