﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../ARM/kern_Assembly.h"

/* =======================================================================
    ARMの未定義命令例外の発生アドレスは、LR-4
    Thumbの未定義命令例外の発生アドレスは、LR-2(Thumb-2 16bit, Thumb-2 32bit)

    VFPv3はVFP例外を発生しないので、VFP有効時の未定義命令例外は
    未定義命令例外としてハンドリングする。
   ======================================================================== */

// UND 例外の動作
//
// まず例外がユーザモードで発生したのか特権モードで発生したのかを調べる
//
// ユーザモードの場合
//   SVC モードへ移行しユーザモードのコンテキストで必要なものを
//   SVC モードのスタックへ保存する。
//
//   例外発生時の命令が VFP 命令
//       VFP が有効
//           未定義命令例外ハンドラを呼ぶ
//       VFP が無効
//           VFP コンテキストスイッチハンドラを呼ぶ
//   例外発生時の命令が VFP 命令以外
//       未定義命令例外ハンドラを呼ぶ
//
// ユーザモード以外
//   KernelPanic
//

EXP_VECTOR_ENTRY(_ZN2nn4kern6ARMv7A27UndefinedInstructionHandlerEv)
        // UND モード -------

        // 例外発生時の状況を調べる
        mrs     sp, spsr;
        and     sp, sp, #HW_PSR_CPU_MODE_MASK
        cmp     sp, #HW_PSR_USR_MODE

        // ユーザモードでなければパニック
        bne     undef_kernel_panic

        // 例外発生時の状況を調べる
        mrs     sp, spsr;
        and     sp, sp, #HW_PSR_THUMB_STATE
        cmp     sp, #HW_PSR_THUMB_STATE

        // ARM モードでなければ例外ハンドラへ
        beq     handle_undef_abort_thumb

        // 復帰先は LR - 4
        sub     lr, lr, #4

        // SVC モードへ移行しつつ復帰用レジスタを保存する
        srsdb   #HW_PSR_SVC_MODE!
        cps     #HW_PSR_SVC_MODE

        // SVC モード -------
handle_undef_abort_vfp:
        // VFP が有効かどうかを調べる
        fmrx    lr, fpexc
        tst     lr, #HW_FPEXC_VFP_ENABLE

        // VFP が有効なら 未定義例外ハンドラへ
        bne     handle_undef_abort

        // コンテキストを保存
        stmdb   sp, {r0-r3, r11-r14}^
        sub     sp, sp, #32

        // VFP コンテキストスイッチハンドラへ
        blx     _ZN2nn4kern6ARMv7A23VfpContextSwitchHandlerEv

        // コンテキストを復帰
        ldmia   sp, {r0-r3, r11-r14}^
        add     sp, sp, #32

        // 例外発生元へ返る
        rfeia   sp!

handle_undef_abort_thumb:
        // UND モード -------

        // 復帰先は LR - 2
        sub     lr, lr, #2

        // SVC モードへ移行しつつ復帰用レジスタを保存する
        srsdb   #HW_PSR_SVC_MODE!
        cps     #HW_PSR_SVC_MODE

        // SVC モード -------
        b       handle_undef_abort_vfp

handle_undef_abort:
        // 未定義命令例外ハンドラを呼び、例外から復帰する
        ldr     lr, =_ZN2nn4kern6ARMv7A26HandleUndefinedInstructionEPNS0_3ARM16ExceptionContextE
        push    {ip, lr}
        b       _ZN2nn4kern6ARMv7A42CallExceptionHandlerAndReturnFromExceptionEv

undef_kernel_panic:
        ldr     lr, = _ZN2nn4kern5PanicEPKciS2_z
        adr     r0, undef_file_name
        ldr     r1, = __LINE__
        adr     r2, undef_panic_msg
        ldr     sp, =NN_KERN_V_ADDR_STACK_CMN_END
        bx      lr

undef_file_name:    .string "kern_UndefinedInstructionHandler.cpp"
undef_panic_msg:    .string "UndefinedInstruction"
SET_SIZE(_ZN2nn4kern6ARMv7A27UndefinedInstructionHandlerEv)

