﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "kern_Assert.h"
#include "../../kern_CPUSelect.h"

namespace nn { namespace kern {

namespace ARMv7A {
class KSimpleLock
{
private:
    NN_ALIGNAS(KCPU::DATA_CACHE_LINE_SIZE) Bit16    m_CurrentTicket;
    NN_ALIGNAS(KCPU::DATA_CACHE_LINE_SIZE) Bit16    m_NextTicket;

public:
    KSimpleLock() : m_CurrentTicket(0), m_NextTicket(0)
    {
        NN_KERN_THIS_ASSERT();
    }

    void Lock()
    {
        NN_KERN_THIS_ASSERT();
        Bit32 tmp0;
        Bit32 tmp1;
        Bit32 tmp2;

        asm volatile(
                "1:  ldrexh %0, %3;"
                "    add    %1, %0, #0x1;"
                "    strexh %2, %1, %3;"
                "    cmp    %2, #0;"
                "    bne    1b;"

                "    sev;"
                "2:  wfe;"
                "    ldrexh %1, %4;"
                "    cmp    %1, %0;"
                "    bne    2b;"
                :"=&r"(tmp0), "=&r"(tmp1), "=&r"(tmp2), "+Q"(m_NextTicket)
                :"Q"(m_CurrentTicket)
                : "memory", "cc");
        KCPU::DataMemoryBarrier();
    }

    void Unlock()
    {
        NN_KERN_THIS_ASSERT();
        Bit32 v = m_CurrentTicket + 1;
        KCPU::DataMemoryBarrier();
        m_CurrentTicket = v;
        KCPU::DataSynchronizationBarrier();
        asm volatile("sev" ::: "memory");
    }
};

}
}}

