﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
#include <nn/nn_Common.h>
#endif

#ifdef NN_SWITCH_INCLUDE_FROM_NON_C
#define NN_KERN_UL(x)       (x)
#else
#define NN_KERN_UL(x)       x ## ul
#endif

//---------------------------------------------------------------------------
// ページテーブル関連
#define NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE          (4096 * 4)
    // 4096 = 4GB(全メモリ空間) / 1MB(HW_MMU7_T1_SEC_SIZE)
    //    4 = sizeof(uint32_t)

#define NN_KERN_DETAIL_MMU_TTBCR                   HW_C2_TTBR0_TABLE_SIZE_8KB
#define NN_KERN_DETAIL_MMU_L1_PAGE_TABLE_0_SIZE    (NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE >> HW_C2_TTBR0_TABLE_SIZE_8KB)

#define NN_KERN_DETAIL_HEAP_ALIGN                           NN_KERN_UL(0x00100000)
#define NN_KERN_DETAIL_STACK_ALIGN                          NN_KERN_UL(0x00001000)
#define NN_KERN_DETAIL_ALIGNUP(x, align)                    (((x) + (align) - 1) & ~((align) - 1))
#define NN_KERN_DETAIL_ALIGNDOWN(x, align)                  ((x) & ~((align) - 1))
#define NN_KERN_DETAIL_HEAP_ALIGNUP(x)                      NN_KERN_DETAIL_ALIGNUP(x, NN_KERN_DETAIL_HEAP_ALIGN)
#define NN_KERN_DETAIL_HEAP_ALIGNDOWN(x)                    NN_KERN_DETAIL_ALIGNDOWN(x, NN_KERN_DETAIL_HEAP_ALIGN)

#define NN_KERN_DETAIL_STACK_ALIGNUP(x)                     NN_KERN_DETAIL_ALIGNUP(x, NN_KERN_DETAIL_STACK_ALIGN)
#define NN_KERN_DETAIL_STACK_ALIGNDOWN(x)                   NN_KERN_DETAIL_ALIGNDOWN(x, NN_KERN_DETAIL_STACK_ALIGN)

//---------------------------------------------------------------------------
// 物理アドレス

//--------------------------------
// ハードウェアにより固定のもの

// kern_MemoryMapCommon で定義


//--------------------------------
// ソフトウェアで取り決めたもの
#define NN_KERN_DETAIL_P_ADDR_FOR_FIX_USES              NN_KERN_DETAIL_P_ADDR_KERNEL_REGION
#define NN_KERN_DETAIL_P_ADDR_FOR_FIX_USES_SIZE         NN_KERN_UL(0x40000)
#define NN_KERN_DETAIL_P_ADDR_FOR_FIX_USES_END          (NN_KERN_DETAIL_P_ADDR_FOR_FIX_USES + NN_KERN_DETAIL_P_ADDR_FOR_FIX_USES_SIZE)

#define NN_KERN_DETAIL_P_ADDR_CODE_MAIN                 NN_KERN_DETAIL_P_ADDR_FOR_FIX_USES_END

#define NN_KERN_DETAIL_P_ADDR_SLAB_HEAP                 NN_KERN_DETAIL_P_ADDR_CODE_MAIN_ZI_END

#define NN_KERN_DETAIL_P_ADDR_SLAB_RESERVED_SIZE        NN_KERN_UL(0x0)

#define NN_KERN_DETAIL_P_ADDR_PT_HEAP                   (NN_KERN_DETAIL_P_ADDR_PT_HEAP_END - NN_KERN_DETAIL_P_ADDR_PT_HEAP_SIZE)
#define NN_KERN_DETAIL_P_ADDR_PT_HEAP_SIZE              NN_KERN_UL(0x00400000)
#define NN_KERN_DETAIL_P_ADDR_PT_HEAP_END               NN_KERN_DETAIL_P_ADDR_KERNEL_REGION_END

#define NN_KERN_DETAIL_P_ADDR_KERNEL_REGION             (NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY)
#define NN_KERN_DETAIL_P_ADDR_KERNEL_REGION_SIZE        NN_KERN_UL(0x01d80000)
#define NN_KERN_DETAIL_P_ADDR_KERNEL_REGION_END         (NN_KERN_DETAIL_P_ADDR_KERNEL_REGION + NN_KERN_DETAIL_P_ADDR_KERNEL_REGION_SIZE)

#define NN_KERN_DETAIL_P_DEBUG_BUFFER                   NN_KERN_DETAIL_P_ADDR_KERNEL_REGION_END
#define NN_KERN_DETAIL_P_DEBUG_BUFFER_SIZE              (NN_KERN_KTRACE_BUFFER_SIZE + NN_KERN_TRACE_BUFFER_SIZE)
#define NN_KERN_DETAIL_P_DEBUG_BUFFER_END               (NN_KERN_DETAIL_P_DEBUG_BUFFER + NN_KERN_DETAIL_P_DEBUG_BUFFER_SIZE)

#define NN_KERN_DETAIL_P_ADDR_HEAP                      NN_KERN_DETAIL_P_DEBUG_BUFFER_END
#define NN_KERN_DETAIL_P_ADDR_HEAP_SIZE                 (NN_KERN_DETAIL_P_ADDR_HEAP_END - NN_KERN_DETAIL_P_ADDR_HEAP)
#define NN_KERN_DETAIL_P_ADDR_HEAP_END                  (NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_END - NN_KERN_DETAIL_P_ADDR_RESERVED_HI_SIZE)

// Debug buffer の内訳
#define NN_KERN_DETAIL_P_KTRACE_BUFFER                  NN_KERN_DETAIL_P_DEBUG_BUFFER
#define NN_KERN_DETAIL_P_KTRACE_BUFFER_SIZE             NN_KERN_KTRACE_BUFFER_SIZE
#define NN_KERN_DETAIL_P_KTRACE_BUFFER_END              (NN_KERN_DETAIL_P_KTRACE_BUFFER + NN_KERN_DETAIL_P_KTRACE_BUFFER_SIZE)

// For KDT
#define NN_KERN_DETAIL_P_TRACE_BUFFER                   NN_KERN_DETAIL_P_KTRACE_BUFFER_END
#define NN_KERN_DETAIL_P_TRACE_BUFFER_SIZE              NN_KERN_TRACE_BUFFER_SIZE
#define NN_KERN_DETAIL_P_TRACE_BUFFER_END               (NN_KERN_DETAIL_P_TRACE_BUFFER + NN_KERN_DETAIL_P_TRACE_BUFFER_SIZE)

//---- カーネル領域詳細
//
// カーネル領域の前から

// FIX 領域 ここから =================
// コア 0 共通スタック
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_0               NN_KERN_DETAIL_P_ADDR_FOR_FIX_USES
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_SIZE          0x2000
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_END           NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_CMN_0 )

// コア 1 共通スタック
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_1               NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_END
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_1_SIZE          NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_1_END           NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_CMN_1 )

// コア 2 共通スタック
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_2              NN_KERN_DETAIL_P_ADDR_STACK_CMN_1_END
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_2_SIZE         NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_2_END          NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_CMN_2 )

// コア 3 共通スタック
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_3              NN_KERN_DETAIL_P_ADDR_STACK_CMN_2_END
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_3_SIZE         NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_STACK_CMN_3_END          NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_CMN_3 )

// コア 0 メインスタック
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0             NN_KERN_DETAIL_P_ADDR_STACK_CMN_3_END
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_SIZE        0x2000
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0 )

// コア 1 メインスタック
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_1             NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_END
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_1_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_1_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_MAIN_1 )

// コア 2 メインスタック
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_2             NN_KERN_DETAIL_P_ADDR_STACK_MAIN_1_END
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_2_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_2_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_MAIN_2 )

// コア 3 メインスタック
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_3             NN_KERN_DETAIL_P_ADDR_STACK_MAIN_2_END
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_3_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_STACK_MAIN_3_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_MAIN_3 )

// コア 0 アイドルスタック
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0             NN_KERN_DETAIL_P_ADDR_STACK_MAIN_3_END
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_SIZE        0x2000
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0 )

// コア 1 アイドルスタック
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_1             NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_END
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_1_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_1_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_IDLE_1 )

// コア 2 アイドルスタック
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_2             NN_KERN_DETAIL_P_ADDR_STACK_IDLE_1_END
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_2_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_2_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_IDLE_2 )

// コア 3 アイドルスタック
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_3             NN_KERN_DETAIL_P_ADDR_STACK_IDLE_2_END
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_3_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_STACK_IDLE_3_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_STACK_IDLE_3 )

// コア 0 固有領域
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0      NN_KERN_DETAIL_P_ADDR_STACK_IDLE_3_END
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_SIZE 0x1000
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_END  NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0 )

// コア 1 固有領域
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_1      NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_END
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_1_SIZE NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_1_END  NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_1 )

// コア 2 固有領域
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_2      NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_1_END
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_2_SIZE NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_2_END  NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_2 )

// コア 3 固有領域
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_3      NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_2_END
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_3_SIZE NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_SIZE
#define NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_3_END  NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_3 )

// コア 0 L1 ページテーブル(16KB境界)
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0          NN_KERN_DETAIL_ALIGNUP(NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_3_END, NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE)
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0_SIZE     NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0_END      NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0 )

// コア 1 L1 ページテーブル(16KB境界)
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_1          NN_KERN_DETAIL_ALIGNUP(NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0_END, NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE)
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_1_SIZE     NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_1_END      NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_1 )

// コア 2 L1 ページテーブル(16KB境界)
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_2          NN_KERN_DETAIL_ALIGNUP(NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_1_END, NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE)
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_2_SIZE     NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_2_END      NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_2 )

// コア 3 L1 ページテーブル(16KB境界)
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_3          NN_KERN_DETAIL_ALIGNUP(NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_2_END, NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE)
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_3_SIZE     NN_KERN_DETAIL_L1_PAGE_TABLE_SIZE
#define NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_3_END      NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_3 )

// L2 ページテーブル全体
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE            NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_3_END
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_SIZE       (1024 * 20)
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_END        NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE )

#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
static_assert(NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_END <= NN_KERN_DETAIL_P_ADDR_FOR_FIX_USES_END, "");
#endif

// L2 ページテーブル 空き領域
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_NOT_USED            NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_NOT_USED_SIZE       (1024 * 3)
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_NOT_USED_END        NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_NOT_USED )

// L2 ページテーブル for SVC スタック領域
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_FOR_SVC_STACK       NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_NOT_USED_END
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_FOR_SVC_STACK_SIZE  (1024 * 8)
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_FOR_SVC_STACK_END   NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_FOR_SVC_STACK )

// コア 0 用 L2 ページテーブル for カーネル領域
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_0                   NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_FOR_SVC_STACK_END
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_0_SIZE              (1024 * 2)
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_0_END               NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_0 )

// コア 1 用 L2 ページテーブル for カーネル領域
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_1                   NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_0_END
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_1_SIZE              (1024 * 2)
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_1_END               NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_1 )

// コア 2 用 L2 ページテーブル for カーネル領域
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_2                   NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_1_END
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_2_SIZE              (1024 * 2)
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_2_END               NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_2 )

// コア 3 用 L2 ページテーブル for カーネル領域
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_3                   NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_2_END
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_3_SIZE              (1024 * 2)
#define NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_3_END               NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_3 )


//---------------------------------------------------------------------------
// 仮想アドレス
#define NN_KERN_DETAIL_V_ADDR_TMPMAP                    (NN_KERN_DETAIL_V_ADDR_TMPMAP_END - NN_KERN_DETAIL_V_ADDR_TMPMAP_SIZE)
#define NN_KERN_DETAIL_V_ADDR_TMPMAP_SIZE               NN_KERN_UL(0x08000000)
#define NN_KERN_DETAIL_V_ADDR_TMPMAP_END                NN_KERN_DETAIL_HEAP_ALIGNDOWN(NN_KERN_DETAIL_V_ADDR_SVC_STACK)

#define NN_KERN_DETAIL_V_ADDR_SVC_STACK                 (NN_KERN_DETAIL_V_ADDR_SVC_STACK_END - NN_KERN_DETAIL_V_ADDR_SVC_STACK_SIZE)
#define NN_KERN_DETAIL_V_ADDR_SVC_STACK_SIZE            ((NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_FOR_SVC_STACK_SIZE / 1024) * 0x00100000)
#define NN_KERN_DETAIL_V_ADDR_SVC_STACK_END             NN_KERN_DETAIL_HEAP_ALIGNDOWN(NN_KERN_DETAIL_V_ADDR_CODE_MAIN)

#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN                 NN_KERN_UL(0xFF000000)

#define NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO            NN_KERN_DETAIL_V_ADDR_CODE_MAIN
#define NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO_SIZE       NN_KERN_UL(0x00200000)
#define NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO_END        (NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO + NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO_SIZE)

#define NN_KERN_DETAIL_V_ADDR_KERNEL_REGION             NN_KERN_DETAIL_V_ADDR_SVC_STACK
#define NN_KERN_DETAIL_V_ADDR_KERNEL_REGION_SIZE        (NN_KERN_DETAIL_V_ADDR_KERNEL_REGION_END - NN_KERN_DETAIL_V_ADDR_KERNEL_REGION)
#define NN_KERN_DETAIL_V_ADDR_KERNEL_REGION_END         NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO_END

// Slab PageTable Heap 領域  =================
#define NN_KERN_DETAIL_V_ADDR_SLAB_HEAP                 (NN_KERN_DETAIL_P_ADDR_SLAB_HEAP + NN_KERN_DETAIL_V_ADDR_LINEAR_MAP_OFFSET)
#define NN_KERN_DETAIL_V_ADDR_PT_HEAP_END               (NN_KERN_DETAIL_P_ADDR_PT_HEAP_END + NN_KERN_DETAIL_V_ADDR_LINEAR_MAP_OFFSET)


// プロセス
#define NN_KERN_DETAIL_V_ADDR_PROCESS                  0x00000000
#define NN_KERN_DETAIL_V_ADDR_PROCESS_SIZE             0x80000000
#define NN_KERN_DETAIL_V_ADDR_PROCESS_END              NN_KERN_CALC_END( NN_KERN_DETAIL_V_ADDR_PROCESS )

// カーネル
#define NN_KERN_DETAIL_V_ADDR_KERNEL                   NN_KERN_DETAIL_V_ADDR_PROCESS_END
#define NN_KERN_DETAIL_V_ADDR_KERNEL_SIZE              NN_KERN_CALC_SIZE( NN_KERN_DETAIL_V_ADDR_KERNEL)
#define NN_KERN_DETAIL_V_ADDR_KERNEL_END               0xFFFFF000

// キャッシュ操作等のためのリニアマップオフセット
#define NN_KERN_DETAIL_V_ADDR_LINEAR_MAP_OFFSET        (NN_KERN_DETAIL_V_ADDR_MAIN_MEMORY - NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY)

//---- カーネル詳細

// メインメモリリニアマッピング領域
#define NN_KERN_DETAIL_V_ADDR_MAIN_MEMORY              0x80000000
#define NN_KERN_DETAIL_V_ADDR_MAIN_MEMORY_SIZE         NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_SIZE
#define NN_KERN_DETAIL_V_ADDR_MAIN_MEMORY_END          NN_KERN_CALC_END( NN_KERN_DETAIL_V_ADDR_MAIN_MEMORY )

// カーネルヒープ
#define NN_KERN_DETAIL_V_ADDR_HEAP                     (NN_KERN_DETAIL_P_ADDR_HEAP + NN_KERN_DETAIL_V_ADDR_LINEAR_MAP_OFFSET)
#define NN_KERN_DETAIL_V_ADDR_HEAP_SIZE                NN_KERN_DETAIL_P_ADDR_HEAP_SIZE
#define NN_KERN_DETAIL_V_ADDR_HEAP_END                 (NN_KERN_DETAIL_V_ADDR_HEAP + NN_KERN_DETAIL_V_ADDR_HEAP_SIZE)

#define NN_KERN_DETAIL_V_DEBUG_BUFFER                  (NN_KERN_DETAIL_P_DEBUG_BUFFER + NN_KERN_DETAIL_V_ADDR_LINEAR_MAP_OFFSET)
#define NN_KERN_DETAIL_V_DEBUG_BUFFER_SIZE             NN_KERN_DETAIL_P_DEBUG_BUFFER_SIZE
#define NN_KERN_DETAIL_V_DEBUG_BUFFER_END              (NN_KERN_DETAIL_V_DEBUG_BUFFER + NN_KERN_DETAIL_V_DEBUG_BUFFER_SIZE)

#define NN_KERN_DETAIL_V_KTRACE_BUFFER                  (NN_KERN_DETAIL_P_KTRACE_BUFFER + NN_KERN_DETAIL_V_ADDR_LINEAR_MAP_OFFSET)
#define NN_KERN_DETAIL_V_KTRACE_BUFFER_SIZE             NN_KERN_DETAIL_P_KTRACE_BUFFER_SIZE
#define NN_KERN_DETAIL_V_KTRACE_BUFFER_END              (NN_KERN_DETAIL_V_KTRACE_BUFFER + NN_KERN_DETAIL_V_KTRACE_BUFFER_SIZE)

#define NN_KERN_DETAIL_V_TRACE_BUFFER                   (NN_KERN_DETAIL_P_TRACE_BUFFER + NN_KERN_DETAIL_V_ADDR_LINEAR_MAP_OFFSET)
#define NN_KERN_DETAIL_V_TRACE_BUFFER_SIZE              NN_KERN_DETAIL_P_TRACE_BUFFER_SIZE
#define NN_KERN_DETAIL_V_TRACE_BUFFER_END               (NN_KERN_DETAIL_V_TRACE_BUFFER + NN_KERN_DETAIL_V_TRACE_BUFFER_SIZE)

//---- カーネル領域詳細
// IO レジスタ
#define NN_KERN_DETAIL_V_ADDR_IO_REGISTER_END          (NN_KERN_DETAIL_V_ADDR_STACK_CMN_0 - 0x1000)


// コア 0 共通スタック
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_0              ((NN_KERN_DETAIL_V_ADDR_STACK_CMN_0_END) - (NN_KERN_DETAIL_V_ADDR_STACK_CMN_0_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_0_SIZE         NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_0_END          (NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_0 - 0x1000)

// コア 0 L1 ページテーブル
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_0          ((NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_0_END) - (NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_0_SIZE))
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_0_SIZE     NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_0_END      (NN_KERN_DETAIL_V_ADDR_STACK_MAIN_0 - 0x1000)

// コア 0 メインスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_0             ((NN_KERN_DETAIL_V_ADDR_STACK_MAIN_0_END) - (NN_KERN_DETAIL_V_ADDR_STACK_MAIN_0_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_0_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_0_END         (NN_KERN_DETAIL_V_ADDR_STACK_IDLE_0 - 0x1000)

// コア 0 アイドルスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_0             ((NN_KERN_DETAIL_V_ADDR_STACK_IDLE_0_END) - (NN_KERN_DETAIL_V_ADDR_STACK_IDLE_0_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_0_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_0_END         (NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_0 - 0x1000)

// コア 0 固有領域
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_0      ((NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_0_END) - (NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_0_SIZE))
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_0_SIZE NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_0_END  (NN_KERN_DETAIL_V_ADDR_STACK_CMN_1 - 0x1000)

// コア 1 共通スタック
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_1              ((NN_KERN_DETAIL_V_ADDR_STACK_CMN_1_END) - (NN_KERN_DETAIL_V_ADDR_STACK_CMN_1_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_1_SIZE         NN_KERN_DETAIL_P_ADDR_STACK_CMN_1_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_1_END          (NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_1 - 0x1000)

// コア 1 L1 ページテーブル
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_1          ((NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_1_END) - (NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_1_SIZE))
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_1_SIZE     NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_1_SIZE
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_1_END      (NN_KERN_DETAIL_V_ADDR_STACK_MAIN_1 - 0x1000)

// コア 1 メインスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_1             ((NN_KERN_DETAIL_V_ADDR_STACK_MAIN_1_END) - (NN_KERN_DETAIL_V_ADDR_STACK_MAIN_1_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_1_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_MAIN_1_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_1_END         (NN_KERN_DETAIL_V_ADDR_STACK_IDLE_1 - 0x1000)

// コア 1 アイドルスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_1             ((NN_KERN_DETAIL_V_ADDR_STACK_IDLE_1_END) - (NN_KERN_DETAIL_V_ADDR_STACK_IDLE_1_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_1_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_IDLE_1_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_1_END         (NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_1 - 0x1000)

// コア 1 固有領域
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_1      ((NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_1_END) - (NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_1_SIZE))
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_1_SIZE NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_1_SIZE
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_1_END  (NN_KERN_DETAIL_V_ADDR_STACK_CMN_2 - 0x1000)

// コア 2 共通スタック
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_2              ((NN_KERN_DETAIL_V_ADDR_STACK_CMN_2_END) - (NN_KERN_DETAIL_V_ADDR_STACK_CMN_2_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_2_SIZE         NN_KERN_DETAIL_P_ADDR_STACK_CMN_2_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_2_END          (NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_2 - 0x1000)

// コア 2 L1 ページテーブル
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_2          ((NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_2_END) - (NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_2_SIZE))
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_2_SIZE     NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_2_SIZE
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_2_END      (NN_KERN_DETAIL_V_ADDR_STACK_MAIN_2 - 0x1000)

// コア 2 メインスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_2             ((NN_KERN_DETAIL_V_ADDR_STACK_MAIN_2_END) - (NN_KERN_DETAIL_V_ADDR_STACK_MAIN_2_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_2_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_MAIN_2_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_2_END         (NN_KERN_DETAIL_V_ADDR_STACK_IDLE_2 - 0x1000)

// コア 2 アイドルスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_2             ((NN_KERN_DETAIL_V_ADDR_STACK_IDLE_2_END) - (NN_KERN_DETAIL_V_ADDR_STACK_IDLE_2_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_2_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_IDLE_2_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_2_END         (NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_2 - 0x1000)

// コア 2 固有領域
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_2      ((NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_2_END) - (NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_2_SIZE))
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_2_SIZE NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_2_SIZE
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_2_END  (NN_KERN_DETAIL_V_ADDR_STACK_CMN_3 - 0x1000)

// コア 3 共通スタック
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_3              ((NN_KERN_DETAIL_V_ADDR_STACK_CMN_3_END) - (NN_KERN_DETAIL_V_ADDR_STACK_CMN_3_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_3_SIZE         NN_KERN_DETAIL_P_ADDR_STACK_CMN_3_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_3_END          (NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_3 - 0x1000)

// コア 3 L1 ページテーブル
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_3          ((NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_3_END) - (NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_3_SIZE))
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_3_SIZE     NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_3_SIZE
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_3_END      (NN_KERN_DETAIL_V_ADDR_STACK_MAIN_3 - 0x1000)

// コア 3 メインスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_3             ((NN_KERN_DETAIL_V_ADDR_STACK_MAIN_3_END) - (NN_KERN_DETAIL_V_ADDR_STACK_MAIN_3_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_3_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_MAIN_3_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_3_END         (NN_KERN_DETAIL_V_ADDR_STACK_IDLE_3 - 0x1000)

// コア 3 アイドルスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_3             ((NN_KERN_DETAIL_V_ADDR_STACK_IDLE_3_END) - (NN_KERN_DETAIL_V_ADDR_STACK_IDLE_3_SIZE))
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_3_SIZE        NN_KERN_DETAIL_P_ADDR_STACK_IDLE_3_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_3_END         (NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_3 - 0x1000)

// コア 3 固有領域
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_3      ((NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_3_END) - (NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_3_SIZE))
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_3_SIZE NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_3_SIZE
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_3_END  (NN_KERN_DETAIL_V_ADDR_STACK_CMN - 0x1000)


// カレントコア共通スタック
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN                ( NN_KERN_DETAIL_V_ADDR_STACK_CMN_END - NN_KERN_DETAIL_V_ADDR_STACK_CMN_SIZE)
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_SIZE           NN_KERN_DETAIL_P_ADDR_STACK_CMN_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_CMN_END            ( NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE - 0x1000 )

// カレントコアL1 ページテーブル
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE            ( NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_END - NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_SIZE )
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_SIZE       NN_KERN_DETAIL_P_ADDR_L1_PAGE_TABLE_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_L1_PAGE_TABLE_END        ( NN_KERN_DETAIL_V_ADDR_STACK_MAIN - 0x1000 )

// カレントコアメインスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN               ( NN_KERN_DETAIL_V_ADDR_STACK_MAIN_END - NN_KERN_DETAIL_V_ADDR_STACK_MAIN_SIZE)
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_SIZE          NN_KERN_DETAIL_P_ADDR_STACK_MAIN_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_MAIN_END           ( NN_KERN_DETAIL_V_ADDR_STACK_IDLE - 0x1000 )

// カレントコアアイドルスタック
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE               ( NN_KERN_DETAIL_V_ADDR_STACK_IDLE_END - NN_KERN_DETAIL_V_ADDR_STACK_IDLE_SIZE)
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_SIZE          NN_KERN_DETAIL_P_ADDR_STACK_IDLE_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_STACK_IDLE_END           ( NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION - 0x1000 )

// カレントコア固有領域
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION        ( NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_END - NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_SIZE)
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_SIZE   NN_KERN_DETAIL_P_ADDR_CORE_LOCAL_REGION_0_SIZE
#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_END    ( NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE - 0x1000 )


// L2 ページテーブル
#define NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE            (NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_END - NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_SIZE)
#define NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_SIZE       NN_KERN_DETAIL_P_ADDR_L2_PAGE_TABLE_SIZE
#define NN_KERN_DETAIL_V_ADDR_L2_PAGE_TABLE_END        ( NN_KERN_DETAIL_V_ADDR_KERNEL_CODE_IO_END - 0x1000 )


// V INITIAL_PROCESS
#define NN_KERN_DETAIL_V_ADDR_INITIAL_PROCESS          (NN_KERN_DETAIL_P_ADDR_INITIAL_PROCESS + NN_KERN_DETAIL_V_ADDR_LINEAR_MAP_OFFSET)
#define NN_KERN_DETAIL_V_ADDR_INITIAL_PROCESS_SIZE     NN_KERN_DETAIL_P_ADDR_INITIAL_PROCESS_SIZE
#define NN_KERN_DETAIL_V_ADDR_INITIAL_PROCESS_END      NN_KERN_CALC_END( NN_KERN_DETAIL_V_ADDR_INITIAL_PROCESS )


//---------------------------------------------------------------------------
// リンカから取得するアドレス

#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
    // 仮想アドレス
    extern uint8_t     Image$$KERNEL_END$$Base[];
    extern uint8_t     Image$$RO_CODE$$Base[];
    extern uint8_t     Image$$RO_CODE_END$$Base[];
    extern uint8_t     Image$$RO$$Base[];
    extern uint8_t     Image$$RO_END$$Base[];
    extern uint8_t     Image$$RW$$Base[];
    extern uint8_t     Image$$RW$$Limit[];
    extern uint8_t     Image$$RW_END$$Base[];
    extern uint8_t     Image$$RO_CODE2$$Base[];
    extern uint8_t     Image$$ZI$$ZI$$Base[];
    extern uint8_t     Image$$ZI$$ZI$$Limit[];

    // 物理アドレス
    extern uint8_t     Load$$RO_CODE$$Base[];
    extern uint8_t     Load$$RO_CODE_END$$Base[];
    extern uint8_t     Load$$RO$$Base[];
    extern uint8_t     Load$$RW$$Base[];
    extern uint8_t     Load$$ZI$$Base[];
    extern uint8_t     Load$$EXCEPTION_VECTOR$$Base[];
    extern uint8_t     Load$$INITIAL_PROCESS$$Base[];

    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_CODE           reinterpret_cast<uintptr_t>(Image$$RO_CODE$$Base)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_CODE_END       reinterpret_cast<uintptr_t>(Image$$RO_CODE_END$$Base)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_CODE_SIZE      (NN_KERN_DETAIL_V_ADDR_CODE_MAIN_CODE_END - NN_KERN_DETAIL_V_ADDR_CODE_MAIN_CODE)

    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO             reinterpret_cast<uintptr_t>(Image$$RO$$Base)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO_END         reinterpret_cast<uintptr_t>(Image$$RO_END$$Base)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO_SIZE        (NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO_END - NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO)

    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW             reinterpret_cast<uintptr_t>(Image$$RW$$Base)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_END         reinterpret_cast<uintptr_t>(Image$$RW$$Limit)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_SIZE        (NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_END - NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW)

    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_ZI          NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_ZI_END      reinterpret_cast<uintptr_t>(Image$$RW_END$$Base)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_ZI_SIZE     (NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_ZI_END - NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_ZI)

    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_CODE           reinterpret_cast<uintptr_t>(Load$$RO_CODE$$Base)
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RO             reinterpret_cast<uintptr_t>(Load$$RO$$Base)
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RW             reinterpret_cast<uintptr_t>(Load$$RW$$Base)
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_ZI             reinterpret_cast<uintptr_t>(Load$$ZI$$Base)
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RW_ZI          NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RW

    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_CODE_END       (NN_KERN_DETAIL_P_ADDR_CODE_MAIN_CODE + NN_KERN_DETAIL_V_ADDR_CODE_MAIN_CODE_SIZE)

    //
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_CODE_SIZE      NN_KERN_CALC_SIZE( NN_KERN_DETAIL_P_ADDR_CODE_MAIN_CODE )
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RO_SIZE        NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO_SIZE
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RW_SIZE        NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_SIZE
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_ZI_SIZE        NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI_SIZE
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RO_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RO )
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RW_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CODE_MAIN_RW )
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_ZI_END         NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CODE_MAIN_ZI )

    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_END            (reinterpret_cast<uintptr_t>(Image$$KERNEL_END$$Base) | 0)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_SIZE           (NN_KERN_DETAIL_V_ADDR_CODE_MAIN_END - NN_KERN_DETAIL_V_ADDR_CODE_MAIN)
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_SIZE           NN_KERN_DETAIL_V_ADDR_CODE_MAIN_SIZE
    #define NN_KERN_DETAIL_P_ADDR_CODE_MAIN_END            (NN_KERN_DETAIL_P_ADDR_CODE_MAIN + NN_KERN_DETAIL_P_ADDR_CODE_MAIN_SIZE)

    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI             (reinterpret_cast<uintptr_t>(Image$$ZI$$ZI$$Base) | 0)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI_END         (reinterpret_cast<uintptr_t>(Image$$ZI$$ZI$$Limit) | 0)
    #define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI_SIZE        NN_KERN_CALC_SIZE(NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI)

    #define NN_KERN_DETAIL_P_ADDR_INITIAL_PROCESS          (reinterpret_cast<uintptr_t>(Load$$INITIAL_PROCESS$$Base) | 0)

    #define NN_KERN_DETAIL_P_ADDR_EXCEPTION_VECTOR_SOURCE  (reinterpret_cast<uintptr_t>(Load$$EXCEPTION_VECTOR$$Base) | 0)

#endif  // ifndef NN_SWITCH_INCLUDE_FROM_NON_C


