﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include <nn/svc/svc_Kernel.h>
#include "../ARM/kern_ExceptionContext.h"

namespace nn { namespace kern { namespace ARMv7A {
    enum ExceptionType
    {
        EXCEPTION_TYPE_PABT,        //!< プリフェッチアボート例外が発生したことを表します。
        EXCEPTION_TYPE_DABT,        //!< データアボート例外が発生したことを表します。
        EXCEPTION_TYPE_UNDEF,       //!< 未定義命令例外が発生したことを表します。
        EXCEPTION_TYPE_VFP,         //!< VFP 例外が発生したことを表します。
        EXCEPTION_TYPE_INVALID_SVC,
        EXCEPTION_TYPE_UNKNOWN,

        EXCEPTION_TYPE_MAX_BIT = (1u << 7)
    };

    void CallExceptionHandlerAndReturnFromException();
    void CallExceptionHandlerAndReturnFromExceptionPrivilegeMode();

    void HandleDataAbort            ( ARM::ExceptionContext* pContext );
    void HandleInstructionAbort     ( ARM::ExceptionContext* pContext );
    void HandleUndefinedInstruction ( ARM::ExceptionContext* pContext );
    void HandleInvalidSvc           ( ARM::ExceptionContext* pContext );

    void ReturnFromException(Result result);

}}}

